% particle fitting by hand
maxfile = 'yttriaParticles_R1scaled.csv';
t=xlsread(maxfile);
a=t(:,2);
b=t(:,3);
% this is used if not using pixel values for the maxima
scale = 1/928.68;
maxima(:,1) = round(a./scale); maxima(:,2) = round(b./scale);
% col 1: x pos
% col 2: y pos
picfile = 'Fitco-effforY2O3.png';

Y = imread(picfile,'png');

w = 38; % half total window
% pad out edges of the map
Y = padarray(Y,[w w]);
c = 1;
%figure
%figure
figure(1)
imshow(Y);
%hold on;
%plot(maxima(:,1)+w,maxima(:,2)+w,'rx');
%hold off;
% check each maxima
disp('Click the left, centre, and right edge of each particle');
disp('Press enter to finish. If no particle, press enter');
for i = 1:length(maxima)
    % display image
    figure(2)
    imshow(Y(maxima(i,2):(maxima(i,2)+2*w),maxima(i,1):(maxima(i,1)+2*w)));
    camzoom(3);
    hold on
    plot(w,w,'rx');
    hold off
    % get input
    in = ginput(3);
    figure(1)
    hold on
    if numel(in)==6
        in(:,1) = in(:,1)+maxima(i,1)+w; % transform to Y space
        in(:,2) = in(:,2)+maxima(i,2)+w;
        p(c,:) = reshape(in',1,6); % store possible particles
        c = c + 1;
        % confirm choice
        plot(maxima(i,1)+w,maxima(i,2)+w,'go');
        hold off
    else
        % reject
        plot(maxima(i,1)+w,maxima(i,2)+w,'ro');
        hold off
    end
end
% now we have the left, centre, right, positions, we need to fit the
% circles to the intensity profiles -- See sphereFit.m