% peak position from two overlapping peaks
% generate two gaussians overlapping
amax = 8;
astep = 1/10;
in = 1:(amax/astep);
r = zeros(1,length(in)); % measured peak
g = r; % guessed peak
for i = in
m1 = 45;
m2 = 55;
s1 = 10;
s2 = 10;
a1 = 1;
a2 = i*astep;
x=0:100;
y1=a1*normpdf(x,m1,s1);
y2=a2*normpdf(x,m2,s2)+rand(1,length(x))*0;
% prep. data
[xData, yData] = prepareCurveData( x, y1+y2 );
% Set up fittype and options.
ft = fittype( 'poly2' ); % use quadratic fit to find peak centre
opts = fitoptions( ft );
opts.Lower = [-Inf -Inf -Inf];
opts.Upper = [Inf Inf Inf];
ex = excludedata( xData, yData, 'range', [max(yData)*0.8 Inf] );
opts.Exclude = ex;
[pks, locs] = findpeaks(y1+y2);
% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );
c = coeffvalues(fitresult);
r(i) = (-c(2)/(2*c(1)));
g(i) = ((a1*m1+a2*m2)/(a1+a2));
% % Plot fit with data.
% h = plot(x,y1,x,y2,x,y1+y2,'rx',x(~ex),fitresult(x(~ex)));
% 
% legend( h, 'y1', 'y2','y1+y2','untitled fit 1', 'Location', 'NorthEast' );
% % Label axes
% xlabel( 'x' );
% ylabel( 'y' );
end
plot(in*astep,r)