function [s]=peakHeights(ions)
%[peakComp]=peakHeights(ions)
% Takes a list of overlapping ions:
% eg  {{1,'Ti','O'} {2,'Fe',2,'O',1}};
% This is two cells, for two ions, in each cell:
% the first col is the charge state, next cols are a valid element
% name followed by an amount.
% This function need the isotopes.m file
% RETURNS: A range list with the heights of each ion's peak
% TODO: Fix bug with single isotope elements
% A London Sept 2013
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
minAbundancy = 0.21; % in percent 0.21 = just enough to exclude O18
pl = cell(length(ions),1); % results cell
% Load isotopes file
isotopesList = load('isotopes.mat');
isotopesList = isotopesList.isotopes;
% build ion mass list
for i = 1:length(ions)
    % loop through all ions
    if isnumeric(cell2mat(ions{i}(1)))
    cs = cell2mat(ions{i}(1)); % charge state
    else
        disp('Invalid charge state:');
        disp(ions{i}(1));
        error(['in ion:',num2str(i)]);
    end
    elements = cell(sum(cellfun(@isstr,ions{i})),1); % cell to store the lists of isotopic masses
    %ison = zeros(sum(cellfun(@isstr,ions{i})),1); % number of each ion
    c = 2;
    ci = 1;
    while c <= length(ions{i})
        % loop through this ion
        if ischar(ions{i}{c})
            %disp(ions{i}{c});
            % Get element masses
            elements{ci} = isotopesList((~cellfun(@isempty,strfind(isotopesList(:,1),strcat(ions{i}{c},'(')))),2:3);
            % Check for number:
            if c < length(ions{i})
                if ischar(ions{i}{c+1})
                    %disp('one element only');
                    % one element only
                    c = c + 1;
                else
                    %disp('number');
                    % Number
                    n = ions{i}{c+1};
                    if n == 1
                        % only one of this element
                    elseif n > 1
                        % more than one of this element
                        % copy this element this many times
                        while n > 1
                            ci = ci+1;
                            elements{ci} = isotopesList((~cellfun(@isempty,strfind(isotopesList(:,1),strcat(ions{i}{c},'(')))),2:3);
                            n = n -1;
                        end
                    end
                    c = c + 2; % move individual ion index
                end
            else
                % end of ions{i} reached
                c= c+1;
            end
        end
        ci = ci +1;
    end
    % take the 1 and 2 elements of isos and matrix multiply abundance and
    % add the masses:
    % take this new list and do it with 3, repeat.
    if length(elements)<2
        peaksList = cell2mat(elements{1}(:,1));
        absList  = cell2mat(elements{1}(:,2))/100;
    else
        % first step (1 and 2)
        % peaks
        a = cell2mat(elements{1}(:,1)');
        b = cell2mat(elements{2}(:,1));
        mat = repmat(a,size(b))+repmat(b,size(a));
        peaksList = mat(:);
        % abundancies
        a = cell2mat(elements{1}(:,2)');
        b = cell2mat(elements{2}(:,2));
        mat = (b/100)*(a/100);
        absList = mat(:);
        if length(elements)>2
            j = 3;
            while j <= length(elements)
                a = peaksList';
                b = cell2mat(elements{j}(:,1));
                mat = repmat(a,size(b))+repmat(b,size(a));
                peaksList = mat(:);
                a = absList';
                b = cell2mat(elements{j}(:,2))/100;
                mat = b*a;
                absList = mat(:);
                j = j + 1;
            end
        end
    end
    % Process the peak list
    % Add up the overlaping peaks to form the ion profile, and devide by
    %charge state
    t=sortrows([peaksList/cs absList(:)]);
    % crop data based on min abundancy
    t = t(t(:,2)>(minAbundancy/100),:);
    % add peaks less than a minimum distance (rf+rs) together
    rrs = rs*sqrt(t(:,1)); % turn sqrt(range width)*sqrt(m/z) = range width
    rrf = rf*sqrt(t(:,1)); % also left of peak (above is right of peak)
    if size(t,1)>1
        p = diff(t(:,1))>(rrs(1:end-1)+rrf(1:end-1)); % BUGGED? see below:
    else
        p=[];
    end
    % dosn't work with {4,'Cr',2} beacuse it overlaps as a single peak with
    % its self... Let's check if p = all zeros
    if sum(p)==0 && ~isempty(p)
        disp(ions2ionStr(ions(i)));
        warning('overlaps with its self!');
        t = [t(:,2)'*t(:,1) sum(t(:,2))];
        % this isn't ideal, it would be better to keep track of the total
        % range of all the overlapping peaks, but this is an OK approx. I
        % think. Later if I redefine the range width to vary with m/z then
        % I will need to track the ranges separately anyway.
        p = [];
    end
    pp = find(p); % peak positions
    s = zeros(length(pp)+1,2); % final list of positions + abundancies
    rtm = 0; % running total mass
    rta = 0; % running total abundancy
    rn = 0; % running number
    is = 1; % index for s array
    if isempty(p)% in the case of an element with one isotope and one ion
        s=t;
    else
        for k = 1:length(p)
            rtm = rtm+t(k,1); % running total mass
            rta = rta+t(k,2); % running total abundancy
            rn = rn+1; % running number
            if k < length(p)
                if p(k)==1
                    s(is,:) = [rtm/rn rta];
                    is = is +1;
                    % finish summing
                    rtm = 0; rta = 0; rn = 0; % reset
                end
            else
                % end of p array
                % need to include last t result.
                if p(k)
                    % peaks are different
                    s(is,:) = [rtm/rn rta];
                    is = is +1;
                    s(is,:) = t(k+1,:);
                    is = is +1;
                else
                    % peaks are similar
                    rtm = rtm + t(k+1,1);
                    rta = rta + t(k+1,2);
                    rn = rn + 1;
                    s(is,:) = [rtm/rn rta];
                    is = is +1;
                end
            end
        end
    end
    %s(:,1) = s(:,1);
    % crop data based on min abundancy
    %s = s(s(:,2)>minAbundancy/100,:);
    pl{i} = s;
    pl{i}(:,3) = i; % set ion ID
end
if(0)
    % plot
    bar(pl{1}(:,1),pl{1}(:,2),0.3)
    hold all
    for i = 2:length(pl)
        bar(pl{i}(:,1),pl{i}(:,2),0.3);
    end
end

% build ranges
rlist=vertcat(pl{:}); % add all ions together
% % rlist(:,3)=0; % initialise ids=0
% % for i = 1:length(pl)
% %     rlist(ismember(rlist(:,1),pl{i}(:,1)),3)=i; % set id for each ion
% % end
rlist = sortrows(rlist,1); % sort range list by m/z
if size(rlist,1)>1
    p = diff(rlist(:,1))>(sqrt(rlist(1:end-1,1))*(rs+rf)); % BUGGED!
else
    p=[];
end
% if isempty(p)
%     p=1;
% end
s = zeros(sum(p)+1,length(ions)+1);
is = 1;
rtm = 0; % running total mass
rn = 0; % running number

if isempty(p) % in the case of an element with one isotope and one ion
    s=rlist(:,1:2);
else
    for k = 1:length(p)
        rtm = rtm+rlist(k,1); % running total mass
        rn = rn+1; % running number
        s(is,rlist(k,3)+1) = rlist(k,2); % set ion
        if k < length(p)
            if p(k)==1
                s(is,1) = rtm/rn;
                is = is +1;
                % finish summing
                rtm = 0; rn = 0; % reset
            end
        else
            % end of p array
            % need to include last t result.
            if p(k)
                % peaks are different
                s(is,1) = rtm/rn;
                s(is,rlist(k,3)+1) = rlist(k,2); % set ion
                is = is +1;
                s(is,1) = rlist(k+1,1);
                s(is,rlist(k+1,3)+1) = rlist(k+1,2); % set ion
                is = is +1;
            else
                % peaks are similar
                rtm = rtm + rlist(k+1,1);
                rn = rn + 1;
                s(is,1) = rtm/rn;
                s(is,rlist(k+1,3)+1) = rlist(k+1,2); % set ion
                is = is +1;
            end
        end
    end
end
% ranges(:,:) = [s(:,1)-rs s(:,1)+rf s(:,2:end)]; % ranges
% binwidth = 0.01;
% lines = zeros(length(ranges(:,1)*6),2);
% for r = 1:length(ranges(:,1))
% lines((r-1)*6+1,1) = ranges(r,1)-binwidth/5;
% lines((r-1)*6+2,1) = ranges(r,1);
% lines((r-1)*6+3,1) = ranges(r,1)+binwidth/5;
% lines((r-1)*6+4,1) = ranges(r,2)-binwidth/5;
% lines((r-1)*6+5,1) = ranges(r,2);
% lines((r-1)*6+6,1) = ranges(r,2)+binwidth/5;
% lines((r-1)*6+2,2) = 1;
% lines((r-1)*6+5,2) = 1;
% end
end