% peak deconvolution for a specific pos file and overlap region
%posFile = 'C:\Users\andy\APT\R14_17870\recons\recon-v01\default\R14_17870-v01.cluster.pos';
%posFile = 'C:\Users\andy\APT\R14_15734 Cr02\recons\recon-v02\default\R14_15734-v02.cluster.pos';
posFile = 'C:\Users\andy\APT\R14_15868 Cr02\recons\recon-v01\default\R14_15868-v01.pos';
% get experimental spectrum
m = loadMasses(posFile);

% overlapping ions:
%ions = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Cr','N'} {1,'Cr','O'} {1,'Fe','N'} {1,'Fe','O'}};
%ions = {{1,'Ti','O'} {2,'Fe',2,'O'}};
%ions = {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'}};
ions = {{2,'Fe'} {2,'Cr'}};
s = peakHeights(ions); % get peak heights

% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
% get range counts
h = subplot(2,2,1);
[ranges,x,y]=rangeCounterSimple(m,[s(:,1)-rs.*sqrt(s(:,1)) s(:,1)+rf.*sqrt(s(:,1))],h);
r = cell2mat(ranges(:,3));
% fitting
% Solve by doing A\B
%ionAmounts = s(:,2:end)\r;
%ionAmounts = lscov((s(:,2:end)),r);
ionAmounts = lsqnonneg((s(:,2:end)),r);
if min(ionAmounts)<0
    disp('WARNING: Negative ion counts found!');
    ionAmounts(ionAmounts<0) = 0; % set negative numbers to zero
end
% the of each ion in each range
ionicRangeComp = (s(:,2:end).*repmat(ionAmounts',size(s(:,1)))./repmat(s(:,2:end)*ionAmounts,size(s(1,2:end))));%.*repmat(r,size(s(1,2:end)));

%disp('Fit Actual Ion1 Ion2...');
%[s(:,1) round([s(:,2:end)*ionAmounts r s(:,2:end).*repmat(ionAmounts',size(s(:,1)))])]
hold on
bar(s(:,1),((s(:,2:end)*ionAmounts)/(max(s(:,2:end)*ionAmounts)))*max(y(2:end-1)),1,'FaceColor','none')
title('Mass Histogram');
hold off
subplot(2,2,2)
bar(s(:,1),[s(:,2:end)*ionAmounts r])
title('Range Counts');
ylabel('Counts');
legend('Fit','Actual Counts')
subplot(2,2,3);
bar(s(:,1),ionicRangeComp,1,'stacked')
ylim([0 1]);
title('Range Composition');
xlabel('m/z amu');
% stuff for the ion legend:
[itab,e]=ions2ionTable(ions); % get ion matrix
elementIdeal = {'Fe' 'Cr' 'Y' 'Ti' 'O' 'C'}';
[e,indexes] = elementSort(e,elementIdeal); % sort elements
itab = itab(:,indexes); % sort matrix
ilist = makeIon(itab,e); % get ion names
legend(ilist{:});
subplot(2,2,4);
bar(s(:,1),(s(:,2:end)*ionAmounts) - r,1);
title('Residuals');
xlabel('m/z amu');