function [ionicRangeComp,failedIons,x,y] = peakDecompPlot(m,peakHeightList,ions)
%[ionicRangeComp] = peakDecompPlot(m,peakHeightList,ions)
% plots peak overlaps given a mass list and a peakHeightList (such as that
% produced by the peakHeights.m function)
% A London Sept 2013

s = peakHeightList; % get peak heights

% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
% get range counts
h = subplot(2,2,1);
[ranges,x,y]=rangeCounterSimple(m,[s(:,1)-rs.*sqrt(s(:,1)) s(:,1)+rf.*sqrt(s(:,1))],h);
r = cell2mat(ranges(:,3));
% fitting
% Solve by doing A\B
%ionAmounts = s(:,2:end)\r;
ionAmounts = lsqnonneg((s(:,2:end)),r);

% the of each ion in each range
ionicRangeComp = (s(:,2:end).*repmat(ionAmounts',size(s(:,1)))./repmat(s(:,2:end)*ionAmounts,size(s(1,2:end))));%.*repmat(r,size(s(1,2:end)));

%disp('Fit Actual Ion1 Ion2...');
%[s(:,1) round([s(:,2:end)*ionAmounts r s(:,2:end).*repmat(ionAmounts',size(s(:,1)))])]
hold on
bar(s(:,1),((s(:,2:end)*ionAmounts)/(max(s(:,2:end)*ionAmounts)))*max(y(2:end-1)),1,'FaceColor','none')
title('Mass Histogram');
hold off
subplot(2,2,2)
bar(s(:,1),[s(:,2:end)*ionAmounts r])
disp(r)
title('Range Counts');
ylabel('Counts');
legend('Fit','Actual Counts')
subplot(2,2,3);
bar(s(:,1),ionicRangeComp,1,'stacked')
ylim([0 1]);
title('Range Composition');
xlabel('m/z amu');
% stuff for the ion legend:
[itab,e]=ions2ionTable(ions); % get ion matrix
elementIdeal = {'Fe' 'Cr' 'Y' 'Ti' 'O' 'C'}';
[e,indexes] = elementSort(e,elementIdeal); % sort elements
itab = itab(:,indexes); % sort matrix
ilist = makeIon(itab,e); % get ion names
legend(ilist{:});
subplot(2,2,4);
bar(s(:,1),(s(:,2:end)*ionAmounts) - r,1);
title('Residuals');
xlabel('m/z amu');

failedIons =(ionAmounts<0);
if min(ionAmounts)<0
    disp('WARNING: Negative ion counts found!');
    disp(strcat('Ions:',num2str(find(ionAmounts<0))));
    ionicRangeComp = 0;
    ionAmounts
    return
    %ionAmounts(ionAmounts<0) = 0; % set negative numbers to zero
end