function [ionicRangeComp,failedIons,sdErr] = peakDecompFailErr(m,peakHeightList)
%[ionicRangeComp,failedIons] = peakDecomp(m,peakHeightList)
% Takes a list of masses and list of peak heights (generated by
% peakHeights.m)
% Returns a % composition of each ion in each range of range-rs:range+rf
% A London Sept 2013
noiseFitMinCount = 10000; % min length of masses to require noise fitting
s = peakHeightList;

% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
range = [s(:,1)-rs.*sqrt(s(:,1)) s(:,1)+rf.*sqrt(s(:,1))];
% get range counts
if length(m)>noiseFitMinCount
    % is the mass list long enough to require noise correction?
    [ranges,~,~] = rangeCounterSimple(m,range);
    r = cell2mat(ranges(:,3));
else
    % if not, use a simple range counter (no noise correction)
    [r,~] = massQuant(m',[range s(:,2:end)]);
    r = r';
end

% fitting
% Solve by doing A\B
[ionAmounts,stdx] = lscov((s(:,2:end)),r);
%stdx = standard error in x
failedIons =(ionAmounts<0);
if min(ionAmounts)<0
    %disp('WARNING: Negative ion counts found!');
    %disp(strcat('Ions:',num2str(find(ionAmounts<0))));
    ionicRangeComp = 0;
    sdErr = 0;
    ionAmounts';
    return
    %ionAmounts(ionAmounts<0) = 0; % set negative numbers to zero
end
if sum(isnan(ionAmounts))
    disp('WARNING: NaN found, aborting');
    ionicRangeComp = 0;
    sdErr = 0;
    return
end
% the of each ion in each range
ionicRangeComp = (s(:,2:end).*repmat(ionAmounts',size(s(:,1)))./repmat(s(:,2:end)*ionAmounts,size(s(1,2:end))));
ionicRangeComp(isnan(ionicRangeComp)) = 0; % remove NaNs from DBZ
sdErr = stdx./ionAmounts;
% actual counts r
% reconstucted counts s(:,2:end)*ionAmounts
% residuals (s(:,2:end)*ionAmounts) - r
end