% simulation detailed on page 278 of Atom Probe Field Ion Microscopy,
% miller 1996
%% setup
% total atoms
N = 10000;
% atomic fractions of B and C
fB = 0.2;
fC = 0.01;
% isotopic abundancies in the 3 ranges (fig 5.3)
C=[0.5 0; 0.5 0.9; 0 0.1];
C2=[ 1 0 0;0 0.5 0; 0 0.5 0.9; 0 0 0.1;]; % inc A
%C=[1 0; 0 0.9; 0 0.1];
%% random data generator
% number of atoms in each range:
R = rand(N,1); % random data
% probablity of ions in a peak is the isotopic abund. times global comp.
% pure B peak = 0.2*0.5             = 0.1
% mixed B+C peak = 0.2*0.5+0.1*0.9  = 0.19
% pure C peak = 0.1*0.1             = 0.01
% So, the intevals are: 0--0.10 0.10--0.29 0.29--0.30
r = [sum(R<=0.1) sum(R>0.1 & R<=0.29) sum(R>0.29 & R<0.3)]
%% simple method (using pure peaks only)
pB = r(1)/(N*C(1,1))
pC = r(3)/(N*C(3,2))
%% least squares method
ionAmounts=(lsqnonneg(C,r')./N)'
%% maximum likelyhood method
fb = C(2,1);   % f''B
fc = C(2,2);   % f''C
df = fc-fb; % Delta f
pBm1 = (-1/(2*N*df))*(  -fb*r(1)+2*fc*r(1)+r(2)*df+fc*r(3) + ...
    sqrt( (-fb*r(1)+2*fc*r(1)+r(2)*df+fc*r(3))^2 - 4*fc*r(1)*(-fb*r(1)+fc*r(1)+r(2)*df-fb*r(3)+fc*r(3)) )  );
pBm2 = (-1/(2*N*df))*( -fb*r(1)+2*fc*r(1)+r(2)*df+fc*r(3) - ...
    sqrt( (-fb*r(1)+2*fc*r(1)+r(2)*df+fc*r(3))^2 - 4*fc*r(1)*(-fb*r(1)+fc*r(1)+r(2)*df-fb*r(3)+fc*r(3)) ) );

% pBm1 = (-1/(2*N*0.4))*( -0.5*r(1)+2*0.9*r(1)+r(2)*0.4+0.9*r(3) + ...
%     sqrt( (-0.5*r(1)+2*0.9*r(1)+r(2)*0.4+0.9*r(3))^2 - 4*0.9*r(1)*(-0.5*r(1)+0.9-r(1)+r(2)*0.4-0.5*r(3)+0.9*r(3)) ) )
% pBm2 = (-1/(2*N*0.4))*( -0.5*r(1)+2*0.9*r(1)+r(2)*0.4+0.9*r(3) - ...
%     sqrt( (-0.5*r(1)+2*0.9*r(1)+r(2)*0.4+0.9*r(3))^2 - 4*0.9*r(1)*(-0.5*r(1)+0.9-r(1)+r(2)*0.4-0.5*r(3)+0.9*r(3)) ) )
if pBm1>=0 && pBm1<=1
    pBm = pBm1;
    pCm = (r(3)*fb*pBm)/(r(1)*fc-pBm*N*df);
else
    pBm = pBm2;
    pCm = (r(3)*fb*pBm)/(r(1)*fc-pBm*N*df);
end

% %% run many times:
sims = 100;
results_simple = zeros(sims,2);
results_ls = zeros(sims,2);
results_mle = zeros(sims,2);
time_ls = zeros(sims,1);
time_mle = zeros(sims,1);
R = zeros(sims,3);
for i=1:sims
    % generate data
    %R = rand(N,1); % random data
    %r = [sum(R<=0.1) sum(R>0.1 & R<=0.29) sum(R>0.29 & R<0.3)];
    r=mnrnd(round(N*(fB+fC)),(C*[fB fC]')./sum([fB fC]));
    R(i,:) = r;
    % quantify
    results_simple(i,:) = [r(1)/(N*C(1,1)) r(3)/(N*C(3,2))];
    %results_ls(i,:) = (lsqnonneg(C,r')./N)';
    tic
    results_ls(i,:) = (lsqnonneg(C,r')')./N;
    time_ls(i) = toc;
    %r = [N-sum(r) r];
    %temp = lscov(C2,(r./sum(r))');
    %results_mle(i,:) = temp(2:3);
    tic
    [p] = mle_solver2(r,C,[0.5 0.5]);
    time_mle(i) = toc;
    results_mle(i,:) = [p(1) p(2)];
end
std(results_simple,1);
std(results_ls,1);
std(results_mle,1);
results_mle=results_mle.*(fB+fC);
100*[std(results_simple,1); std(results_ls,1); std(results_mle,1)]./[mean(results_simple,1); mean(results_ls,1); mean(results_mle,1)]