function [ionicRangeComp] = peakDecomp(m,peakHeightList)
%[ionicRangeComp,xrange] = peakDecomp(m,ions)
% Takes a list of masses and list of peak heights (generated by
% peakHeights.m
% Returns a % composition of each ion in each range of range-rs:range+rf
% A London Sept 2013
s = peakHeightList;

% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
range = [s(:,1)-rs.*sqrt(s(:,1)) s(:,1)+rf.*sqrt(s(:,1))];
% get range counts
if length(m)>noiseFitMinCount
    % is the mass list long enough to require noise correction?
    [ranges,~,~] = rangeCounterSimple(m,range);
    r = cell2mat(ranges(:,3));
else
    % if not, use a simple range counter (no noise correction)
    [r,~] = massQuant(m',[range s(:,2:end)]);
    r = r';
end

% fitting
% Solve by doing A\B
ionAmounts = lsqnonneg((s(:,2:end)),r);
if min(ionAmounts)<0
    disp('WARNING: Negative ion counts found, aborting');
    ionicRangeComp = 0;
    ionAmounts
    return
end
if sum(isnan(ionAmounts))
    disp('WARNING: NaN found, aborting');
    ionicRangeComp = 0;
    return
end
% the of each ion in each range
ionicRangeComp = (s(:,2:end).*repmat(ionAmounts',size(s(:,1)))./repmat(s(:,2:end)*ionAmounts,size(s(1,2:end))));%.*repmat(r,size(s(1,2:end)));

% actual counts r
% reconstucted counts s(:,2:end)*ionAmounts
% residuals (s(:,2:end)*ionAmounts) - r
end