% peak area experiment
areas = [1000, 500, 1000];
sigmas = [0.1 0.1 0.05]; % half the FWHM
H = 1*sqrt(2*log(2))*sigmas;
bins = 1000; % number of bins for histogram
a1 = ones(size(areas,1));
a2 = a1;
for i=1:length(areas)
   n=randn(areas(i),1)*sigmas(i); % generate sample
   [y,x]=hist(n,bins);
   % remove duplicates
   c=cumsum(y);
   [q,ia] = unique(c);
   % calc areas
   a1(i) = sum(n>-H(i) & n<H(i));
   a2(i) = sum( n>interp1(q,x(ia),max(q)*0.25) & n<interp1(q,x(ia),max(q)*0.75) );
end
%disp(a1);%FWHM
%disp(a2);%50% of cdf
tests = 5;
c1 = zeros(bins,tests);
a1=zeros(tests,1);
x1=a1;x0=a1;x2=a1;
for i = 1:tests
% using a real set of peaks
load('feMass.mat');
atomNum=100; % number of atoms to simulate
m = interp1(data(2,:),data(1,:),rand(atomNum,1),'linear');
[y,x]=hist(m,bins);
%subplot(1,tests,i);
%bar(x,y,1);
%set(gca,'YScale','log')
%disp('select peak start and finish');
%[points,~]=ginput(2);
y2 = zeros(size(y));
% set outside the peak to 0
y2(x>=points(1) & x<=points(2)) = y(x>=points(1) & x<=points(2));
c=cumsum(y2);
c1(:,i)=c;
% normalise
c = (c-min(c))./max(c-min(c));
[q,ia] = unique(c);
% plot point
%hold on
%plot(interp1(q,x(ia),max(q)*0.5),50,'rx');
x0(i)=interp1(q,x(ia),max(q)*0.25);
x1(i)=interp1(q,x(ia),max(q)*0.5);
x2(i)=interp1(q,x(ia),max(q)*0.75);
%hold off
a1(i)=sum( m>interp1(q,x(ia),max(q)*0.25) & m<interp1(q,x(ia),max(q)*0.75) );
end