% particle finder manual
% specify particle centres manually

%a=double(imread('G:\TEM\oj2200\20140709\A1\randomBulk\loading_02b.png'));
%ff = 'F:\TEM\oj2200\C2 liftout\130307\EFTEM\Region 7\MSA\Eigen image 2.tif';
%a = -double(imread(ff));
%fileName = 'F:\TEM\oj2200\20140615\C010\R4\factors.h5';
init=1;
if init==1
    % FeY
    %fileName = 'F:\TEM\oj2200\20140709\A1\randomBulk\loadings.h5'; % -3
    %fileName = 'F:\TEM\oj2200\20140709\A1\largeParticle\bss_loadings.h5'; % 4
    fileName = 'F:\TEM\oj2200\20140615\A1\R1-bulk\loadings.h5'; % 3+4
    [data,sc,sc_units]=eftemH5(fileName);
    a=data(:,:,3:4);
    aa=sum(a,3);
    aa =medfilt2(aa,[9 9]);
end
if init==1
    subplot(1,2,1);
    imagesc(aa);
    
    boundingBox = cell(1);
    subImage = cell(1);
    centres = cell(1);
    index = 1;
    disp('Click left-top, centre and bottom-right positions');
    [gx,gy] = ginput(3);
    while length(gx)==3
        subplot(1,2,2)
        boundingBox{index} = [gx(1) gy(1);gx(3) gy(3)];
        centres{index} = [gx(2) gy(2)];
        subImage{index} = aa(1:size(aa,2)>gy(1) & 1:size(aa,2)<gy(3),1:size(aa,1)>gx(1) & 1:size(aa,1)<gx(3));
        imagesc(subImage{index});
        subplot(1,2,1);
        hold on
        text(gx(2),gy(2),num2str(index),'BackgroundColor',[.5 .5 .5]);
        hold off
        index = index + 1;
        disp('Click left-top, centre and bottom-right positions');
        [gx,gy] = ginput(3);
    end
end

num_particles = size(subImage,2);

gfits = cell(num_particles,2);
% loop through list and fit ellipses
for k = 1:num_particles;
    % load sub-image
    sub_imageR = subImage{k};
    % find centre
    [ny,nx] = size(sub_imageR);
    [px,py] = meshgrid(1:nx,1:ny);
    M=sub_imageR;
    % 2D gaussian fit object
    gauss2 = fittype( @(a1, sigmax, sigmay, x0,y0,bg0,bg1,bg2, x, y) bg0+bg1*x+bg2*y+a1*exp(-(x-x0).^2/(2*sigmax^2)-(y-y0).^2/(2*sigmay^2)),...
        'independent', {'x', 'y'},'dependent', 'z' );
    bg0 = min(M(:));
    bg1=0; bg2=0;
    a1 = max(M(:))-bg0; % height, determine from image. may want to subtract background
    sigmax = 2; % guess width
    sigmay = 2; % guess width
    x0 = nx/2; % guess position (center seems a good place to start)
    y0 = ny/2;
    
    % compute fit
    [sf,gof] = fit([px(:) py(:)],double(M(:)),gauss2,'StartPoint',[a1, sigmax, sigmay, x0, y0, bg0, bg1, bg2],'Lower',[0, 0, 0, 0, 0, -Inf, -Inf, -Inf]);
    gfits{k,1} = {sf,gof};
    %clf; plot(sf,[px(:) py(:)],M(:));
    %pause
    ellipse2 = fittype( @(a1, rx, ry, x0,y0,bg0,bg1,bg2, x, y) bg0+bg1*x+bg2*y+a1*real(sqrt(1-((x-x0)/rx).^2-((y-y0)/ry).^2)),'independent', {'x', 'y'},'dependent', 'z' );
    [sf,gof] = fit([px(:) py(:)],double(M(:)),ellipse2,'StartPoint',[a1, sf.sigmax, sf.sigmay, x0, y0, sf.bg0, sf.bg1, sf.bg2]);
    gfits{k,2} = {sf,gof};
    %     clf; plot(sf,[px(:) py(:)],M(:));
    %     pause
end

% statistics
result = zeros(num_particles,14);
result(:,1) = 1:num_particles;
for k = 1:num_particles
    result(k,2) = gfits{k,1}{1}.a1;
    result(k,3) = gfits{k,1}{1}.x0+boundingBox{k}(1,1);
    result(k,4) = gfits{k,1}{1}.y0+boundingBox{k}(1,2);
    result(k,5) = abs(gfits{k,1}{1}.sigmax);
    result(k,6) = abs(gfits{k,1}{1}.sigmay);
    result(k,7) = gfits{k,1}{2}.rsquare;
    result(k,8) = gfits{k,2}{1}.a1;
    result(k,9) = gfits{k,2}{1}.x0+boundingBox{k}(1,1);
    result(k,10) = gfits{k,2}{1}.y0+boundingBox{k}(1,2);
    result(k,11) = abs(gfits{k,2}{1}.rx);
    result(k,12) = abs(gfits{k,2}{1}.ry);
    result(k,13) = gfits{k,2}{2}.rsquare;
end
%result(:,14) = vertcat(s.Eccentricity);
result(:,15) = mean(result(:,5)+result(:,6),2)*2*sqrt(2*log(2)); % FWHM
result(:,16) = sqrt(result(:,11).*result(:,12)); % equivalent radius
% result(:,15) = vertcat(s.MajorAxisLength);
% result(:,16) = vertcat(s.MinorAxisLength);
headers = {'ID','Gamp','Gx','Gy','Gsx','Gsy','GR2','Camp','Cx','Cy','Crx','Cry','CR2','Ecc','Gfwhm','Cradius'};
% find outliers based on FWHM, radius, eccentricity, centre and fit
% amplitude
Eccec_limit = 0.8;
%p=result(:,14)<Eccec_limit & result(:,8)>0;
p=result(:,8)>0;
% check found centre is in bounding box
for k=1:num_particles
    if result(k,9)<boundingBox{k}(1,1) || result(k,9)>(boundingBox{k}(2,1)) ...
            || result(k,10)<boundingBox{k}(1,2) || result(k,10)>(boundingBox{k}(2,2))
        p(k) = 0;
    end
end

% save results in full
%scale to sc first
result(:,[3 4 5 6 9 10 11 12 15 16]) = result(:,[3 4 5 6 9 10 11 12 15 16]).*sc(1);
f = fileparts(fileName);
cell2csv([f '\sizes.csv'],[headers; num2cell(result)]);

% Fit the FWHM and radii and exclude results where the fits disagree
% ffit = fit(result(p,15),result(p,16),'poly1','robust','bisquare');
% rsd = result(p,16)-ffit(result(p,15)); % residuals
% q=rsd>(mean(rsd)-std(rsd)*2) & rsd<(mean(rsd)+std(rsd)*2);
% refine p and fix results
%p(p)=q;

result2 = result(p,:);

% imagesc(aa);
% for k=1:numel(s)
%     annotation('textbox',[0.13+(s(k).Centroid(1)/size(aa,1))*0.75 0.05+(s(k).Centroid(2)/size(aa,2))*0.82 0.1 0.1],'string',num2str(k));
% end
% imagesc(aa);
% hold on
% scatter(result(p,3),result(p,4),result(p,15),'go')
% scatter(result(~p,3),result(~p,4),result(~p,15),'ro')
% hold off
% plot results
figure;
imagesc((1:size(aa,1))*sc(1),(1:size(aa,2))*sc(2),aa);
hold all
for k = 1:num_particles
    if p(k)
        circle(result(k,9),result(k,10),result(k,16));
    end
end
hold off
