%a=double(imread('G:\TEM\oj2200\20140709\A1\randomBulk\loading_02b.png'));
%ff = 'F:\TEM\oj2200\C2 liftout\130307\EFTEM\Region 7\MSA\Eigen image 2.tif';
%a = -double(imread(ff));
%fileName = 'F:\TEM\oj2200\20140615\C010\R4\factors.h5';
fileName = 'F:\TEM\oj2200\20140615\B05\R5\bss_factors.h5';
[data,sc,sc_units]=eftemH5(fileName);
a=data(:,:,3);
aa=sum(a,3);
aa =medfilt2(aa,[9 9]);
subplot(1,2,1);
b = bpass(aa,1,20)-bpass(aa,1,5);imagesc(aa)
[lvl,bw]=thresh_tool(b);
%lvl=0.003;
bw=im2bw(b, lvl);
subplot(1,2,2);
p1 = bwmorph(bwmorph(bw,'clean'),'dilate',3);
% delete regions
disp('L-click on areas that are not particles, R-click to end');
[p2,delete_particles] = imfill(~p1);
[p2]=imfill(~p1,delete_particles);
p2 = ~p2;
imagesc(p2);
% get region props data
s = regionprops(p2,'centroid','BoundingBox','EquivDiameter','PixelList','PixelIdxList','Image','Orientation','Eccentricity','MajorAxisLength','MinorAxisLength');
% size dist: hist(vertcat(s.EquivDiameter));
subplot(1,2,1);
maxList = zeros(numel(s),2);
gfits = cell(numel(s),2);
% loop through list and fit ellipses
for k = 1:numel(s)
    idx = s(k).PixelIdxList;
    pixels_in_region_k = aa(idx);
    [max_value, max_idx] = max(pixels_in_region_k);
    maxList(k,:) = s(k).PixelList(max_idx, :);
    %plot(maxList(k,1)-s(k).BoundingBox(1), maxList(k,2)-s(k).BoundingBox(2), '*');
    % rotate image
    sub_image = (aa(1:size(aa,1)>s(k).BoundingBox(2) & 1:size(aa,1)<(s(k).BoundingBox(2)+s(k).BoundingBox(4)),1:size(aa,2)>s(k).BoundingBox(1) & 1:size(aa,2)<(s(k).BoundingBox(1)+s(k).BoundingBox(3))));
    %sub_image = sub_image-median(sub_image(:)); % remove median
    sub_imageR = sub_image;%imrotate(sub_image,-s(k).Orientation);
%     imagesc(sub_imageR);
%     pause
    % find centre
    [ny,nx] = size(sub_imageR);
    [px,py] = meshgrid(1:nx,1:ny);
    M=sub_imageR;
    % 2D gaussian fit object
    gauss2 = fittype( @(a1, sigmax, sigmay, x0,y0,bg0,bg1,bg2, x, y) bg0+bg1*x+bg2*y+a1*exp(-(x-x0).^2/(2*sigmax^2)-(y-y0).^2/(2*sigmay^2)),...
        'independent', {'x', 'y'},'dependent', 'z' );
    bg0 = min(M(:));
    bg1=0; bg2=0;
    a1 = max(M(:))-bg0; % height, determine from image. may want to subtract background
    sigmax = 2; % guess width
    sigmay = 2; % guess width
    x0 = nx/2; % guess position (center seems a good place to start)
    y0 = ny/2;
    
    % compute fit
    [sf,gof] = fit([px(:) py(:)],double(M(:)),gauss2,'StartPoint',[a1, sigmax, sigmay, x0, y0, bg0, bg1, bg2],'Lower',[0, 0, 0, 0, 0, -Inf, -Inf, -Inf]);
    gfits{k,1} = {sf,gof};
    %clf; plot(sf,[px(:) py(:)],M(:));
    %pause    
    ellipse2 = fittype( @(a1, rx, ry, x0,y0,bg0,bg1,bg2, x, y) bg0+bg1*x+bg2*y+a1*real(sqrt(1-((x-x0)/rx).^2-((y-y0)/ry).^2)),'independent', {'x', 'y'},'dependent', 'z' );
    [sf,gof] = fit([px(:) py(:)],double(M(:)),ellipse2,'StartPoint',[a1, sf.sigmax, sf.sigmay, x0, y0, sf.bg0, sf.bg1, sf.bg2]);
    gfits{k,2} = {sf,gof};
%     clf; plot(sf,[px(:) py(:)],M(:));
%     pause    
end

% statistics
result = zeros(numel(s),14);
result(:,1) = 1:numel(s);
for k = 1:numel(s)
    result(k,2) = gfits{k,1}{1}.a1;
    result(k,3) = gfits{k,1}{1}.x0+s(k).BoundingBox(1);
    result(k,4) = gfits{k,1}{1}.y0+s(k).BoundingBox(2);
    result(k,5) = abs(gfits{k,1}{1}.sigmax);
    result(k,6) = abs(gfits{k,1}{1}.sigmay);
    result(k,7) = gfits{k,1}{2}.rsquare;
    result(k,8) = gfits{k,2}{1}.a1;
    result(k,9) = gfits{k,2}{1}.x0+s(k).BoundingBox(1);
    result(k,10) = gfits{k,2}{1}.y0+s(k).BoundingBox(2);
    result(k,11) = abs(gfits{k,2}{1}.rx);
    result(k,12) = abs(gfits{k,2}{1}.ry);
    result(k,13) = gfits{k,2}{2}.rsquare;
end
result(:,14) = vertcat(s.Eccentricity);
result(:,15) = mean(result(:,5)+result(:,6),2)*2*sqrt(2*log(2)); % FWHM
result(:,16) = sqrt(result(:,11).*result(:,12)); % equivalent radius
% result(:,15) = vertcat(s.MajorAxisLength);
% result(:,16) = vertcat(s.MinorAxisLength);

% find outliers based on FWHM, radius, eccentricity, centre and fit
% amplitude
Eccec_limit = 0.8;
p=result(:,14)<Eccec_limit & result(:,8)>0;
for k=1:numel(s)
    if result(k,9)<s(k).BoundingBox(1) || result(k,9)>(s(k).BoundingBox(1)+s(k).BoundingBox(3)) ...
        || result(k,10)<s(k).BoundingBox(2) || result(k,10)>(s(k).BoundingBox(2)+s(k).BoundingBox(4))
    p(k) = 0;
    end
end

% Fit the FWHM and radii and exclude results where the fits disagree
% ffit = fit(result(p,15),result(p,16),'poly1','robust','bisquare');
% rsd = result(p,16)-ffit(result(p,15)); % residuals
% q=rsd>(mean(rsd)-std(rsd)*2) & rsd<(mean(rsd)+std(rsd)*2);
% refine p and fix results
%p(p)=q;

result2 = result(p,:);

% imagesc(aa);
% for k=1:numel(s)
%     annotation('textbox',[0.13+(s(k).Centroid(1)/size(aa,1))*0.75 0.05+(s(k).Centroid(2)/size(aa,2))*0.82 0.1 0.1],'string',num2str(k));
% end
% imagesc(aa);
% hold on
% scatter(result(p,3),result(p,4),result(p,15),'go')
% scatter(result(~p,3),result(~p,4),result(~p,15),'ro')
% hold off
% plot results
figure;
imagesc(aa);
hold all 
for k = 1:numel(s)
    if p(k)
        circle(result(k,9),result(k,10),result(k,16));
    end
end
hold off