% number density plotter
% after running numberDensity.m run this to plot the data
% if using numberDensity2.m use:
vol = ones(matn,1)*1E27;

for m = 1:length(sndn)
    subplot(2,4,m);
    bar(x(1:end-1),sndn{m}(1:end-1)./(vol(m)*1E-27),1);
    hold all
    errors = (sqrt(histCounts{m}(1:end-1))./histCounts{m}(1:end-1)).*(sndn{m}(1:end-1)./(vol(m)*1E-27));
    errorbar(x(1:end-1),sndn{m}(1:end-1)./(vol(m)*1E-27),errors);
    title(mats(m));
    ylim([0 5E23]);
    xlim([0 10]);
    hold off
end

% export results table:
% mat irrdTemp r density err
%exportTable(:,3) = [exportTable];
exportTable = cell((length(x)-1)*8,5);
i = 1;
for m = 1:length(sndn)
    ii = i+length(x)-2;
    % should use codeConvert instead
    if strcmp(mats{m},'B1')
        irrdTemp = '500';
        material = 'Fe ODS';
    elseif strcmp(mats{m},'B3')
        irrdTemp = '600';
        material = 'Fe ODS';
    elseif strcmp(mats{m},'B2')
        irrdTemp = '700';
        material = 'Fe ODS';
    elseif strcmp(mats{m},'C1')
        irrdTemp = '500';
        material = 'Fe-14Cr ODS';
    elseif strcmp(mats{m},'C3')
        irrdTemp = '600';
        material = 'Fe-14Cr ODS';
    elseif strcmp(mats{m},'C2')
        irrdTemp = '700';
        material = 'Fe-14Cr ODS';
    elseif strcmp(mats{m},'Fe-14Cr ODS')
        irrdTemp = '0';
        material = 'Fe-14Cr ODS';
    elseif strcmp(mats{m},'Fe ODS')
        irrdTemp = '0';
        material = 'Fe ODS';
    else
        irrdTemp = 'err';
        material = 'err';
    end
    exportTable(i:ii,1) = {material}; % mat factor
    exportTable(i:ii,2) = {irrdTemp}; % irrdTemp
    exportTable(i:ii,3) = num2cell(x(1:end-1)'); % radius
    exportTable(i:ii,4) = num2cell(sndn{m}(1:end-1)./(vol(m)*1E-27))'; % density
    exportTable(i:ii,5) = num2cell(errors)'; % err
    i = i + length(x)-1;
end
if(1)    % write output file?
    e2 = strCellConvert(exportTable); % add str limiters
    e2 = [{'mat' 'irrdTemp' 'r' 'density' 'err'}; e2];
    cell2csv('sndn2.csv',e2,',')
end