% numberDensity2, as numberDensity.m but generates histograms per run not
% averaged over the whole material
% generate number density histograms normalised to number density
% A London oct 2013

% get cluster data first
opts = {'Irrd'};
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);

opts = {'UnirrdFull'};
[rangeFileList2,posFileList2,clusterFileList2,volList2,matList2]=clusterFiles(opts);

% concat lists
rangeFileList = [rangeFileList rangeFileList2];
posFileList = [posFileList; posFileList2];
clusterFileList = [clusterFileList clusterFileList2];
volList = [volList volList2];
matList = [matList matList2];

% count clusters from cluster files
countList = zeros(length(clusterFileList),1);
extentZ = cell(length(clusterFileList),1);
x = (0.5:0.5:10.5)'; % bin edges in nm
sndnn = cell(length(clusterFileList),1); % store histograms here {m}(x,y)
sndni = cell(length(clusterFileList),1); % store histograms here {m}(x,y)
for f=1:length(clusterFileList)
    cf = clusterFileList{f};
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ{f},nTable,dmax,dbulk,derode,nmin,core,countList(f)] = clusterExtent(cf);
    nout = hist(extentZ{f},x)';
    % individual histogram
    sndnn{f} = nout(1:end); % counts
    sndni{f} = nout(1:end)./(volList{f}*1E-27);
end

% get all different materials types
mats = unique(matList);
matn = length(mats);
sndn = cell(matn,1); % store histograms here {m}(x,y)
histCounts = cell(matn,1); % store histograms here {m}(x,y)
sndn(:) = {zeros(length(x),1)};
histCounts(:) = {zeros(length(x),1)};
% sum histograms
for f = 1:length(clusterFileList)
    for m = 1:matn % loop through all materials
        % find which material it is and add it to the total histogram
        if strcmp(matList{f},mats{m})
            histCounts{m} = histCounts{m}+sndnn{f};
            sndn{m} = sndn{m} + sndni{f};
        end
    end
end