% generate number density histograms normalised to number density
% A London oct 2013

% get cluster data first
opts = {'Irrd'};
[rangeFileList,posFileList,clusterFileList,volList,matList]=clusterFiles(opts);

opts = {'Unirrd'};
[rangeFileList2,posFileList2,clusterFileList2,volList2,matList2]=clusterFiles(opts);

% concat lists
rangeFileList = [rangeFileList rangeFileList2];
posFileList = [posFileList; posFileList2];
clusterFileList = [clusterFileList clusterFileList2];
volList = [volList volList2];
matList = [matList matList2];

% count clusters from cluster files
countList = zeros(length(clusterFileList),1);
extentZ = cell(length(clusterFileList),1);
for f=1:length(clusterFileList)
    cf = clusterFileList{f};
    [elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,extentZ{f},nTable,dmax,dbulk,derode,nmin,core,countList(f)] = clusterExtent(cf);
end
mats = unique(matList);
matn = length(mats);
vol = zeros(matn,1);
sndn = cell(matn,1); % store histograms here {m}(x,y)
x = 0.5:0.5:10.5; % bin edges in nm
% generate histograms
for m = 1:matn % B or C
    code = mats{m}; % eg 'C3'
    vol(m) = sum(cell2mat(volList(strcmp(matList,code)))); % get volume
    a = extentZ(strcmp(matList,code));
    r = []; % unwrap radii results
    for i = 1:length(a)
        r = [r; a{i}];
    end
    sndn{m} = hist(r,x);
end