function [expNoiseFit,expPredictor,stderror] = noiseFit(x,y,xRange)
%[expNoiseFit,expPredictor,stderror] = noiseFit(x,y,xRange)
% fits an exp(sqrt(x)) noise background to pre-peak atom probe mass spectra
% x and y must be n-by-1
% A London Nov 2013
ME = MException('rngCounter:nlinfit', strcat('failed at range:',num2str(xRange(1))));
try
    % Set up fittype and options.
    ft = fittype( 'exp1' );
    opts = fitoptions( ft );
    opts.Display = 'Off';
    opts.Lower = [-Inf -Inf];
    opts.StartPoint = [1 0];
    opts.Upper = [Inf 0];
    %opts.Robust = 'on';
    [expNoiseFit, ~] = fit(x.^2,y,ft,opts);
    % 95% predictor lines
    % the predint function seems to give huge errors, like +/-1E30...
    expPredictor = predint(expNoiseFit,xRange.^2,0.99,'observation','off');
    % use the standard deviation x 2 for the predictor
    % rangeX2 = xRange.^2; % old code, could be removed
    %expPredictor(:,1) = expNoiseFit(preNoiseX.^2)-std(preNoiseY-expNoiseFit(preNoiseX.^2));
    %expPredictor(:,2) = expNoiseFit(preNoiseX.^2)+std(preNoiseY-expNoiseFit(preNoiseX.^2));
    stderror = std(y-expNoiseFit(x.^2));
%     figure
%     plot(x,y,'kx',x,expNoiseFit(x.^2),'b-');
catch ME
    disp('Fitting failed use flat min noise');
    expNoiseFit = cfit(fittype('exp1'),mean(y),0);
    % errors and predictors
    expPredictor = zeros(length(x),2);
    expPredictor(1:1:end,1) = mean(y)-std(y);
    expPredictor(1:1:end,2) = mean(y)+std(y);
    stderror = std(y);
    %ME
end

% check fit
if(expNoiseFit.b >= 0 )
    %disp('exponent > 0, this usually means there is bad fitting, using flat minimum instead');
    %expNoiseFit = cfit(fittype('exp1'),mean(y),0);
    expPredictor(1:1:end,1) = mean(y)-std(y);
    expPredictor(1:1:end,2) = mean(y)+std(y);
    stderror = std(y);
end
end