% import nanoindenter xls data
% gets the average hardness from a set depth:
depths = [100 400]; % depth in nm
% get file names
% open all the files in one folder
rootFolder = 'C:\Users\andy\Documents\indents\';
warning('off','MATLAB:xlsread:RangeIncompatible');
bins = 1;
outlierZ = 3; % number of sigmas from mu of modulus or hardness
dataHeaders = {'Displacement','Load','Time','HarmonicContactStiffness','Hardness','Modulus'};
dataCols = length(dataHeaders);
xaxis = 1; % columns from file.xls[Sheet!Test 001]
yaxis = 5;
xlsMaxRow = 1040000;
names = dir([rootFolder '*.xls']);
names = {names.name}';
files = cell(length(names),1);
allData = cell(length(names),1);
for i = 1:length(names)
   disp(names{i});
   % open file
   first = xlsread([rootFolder names{i}],1,'','basic');
   % this should get the first page including the summary
   % remove obvious outliers
   tagged = (first(1:end-3,1) < first(end-2,1)-outlierZ*first(end-1,1)) |(first(1:end-3,1) > first(end-2,1)+outlierZ*first(end-1,1));
   tagged =  tagged | ((first(1:end-3,2) < first(end-2,2)-outlierZ*first(end-1,2)) |(first(1:end-3,2) > first(end-2,2)+outlierZ*first(end-1,2)));
   % extract the number of tests from the summary
   numTests = size(first,1)-3;
   % tagged/missing data
   tagged = tagged | isnan(first(1:end-3,1));
   tests = cell(numTests,1);
   for j=numTests:-1:1
       testStr = ['Test ',num2str(j,'%03.0f')];
       testStrTag = [testStr ' Tagged'];
       if ~tagged(j)
           try
               tests{j}=xlsread([rootFolder names{i}],testStr,'','basic');
               tests{j} = tests{j}(:,2:end); % remove first column
           catch
               disp(testStrTag);
               tagged(j) = 1;
               %tests{j}=xlsread([rootFolder names{i}],testStrTag,'','basic');
           end
           % columns
           %Displacement       %Load       %Time       %HarmonicContactStiffness       %Hardness       %Modulus
       else
           disp(testStrTag);
       end
   end
   allData{i} = tests{~tagged};
   % digitise
   compact = vertcat(tests{~tagged});
   [~,xout]= hist(compact(:,1),bins);
   xout = [0 xout];
   [n,bin] = histc(compact(:,1),xout);
   files{i} = zeros(bins,dataCols*2-1);
   
   for j=1:bins
       p = compact(:,1)>=depths(1) & compact(:,1)<=depths(2);
       files{i}(j,:) = [mean(compact(p,:),1) std(compact(p,2:end),1)];
   end
end
warning('on','MATLAB:xlsread:RangeIncompatible');
% summarise
namesCol = cell(length(names)*bins,1);
for i=1:length(names)
    namesCol(((i-1)*bins+1):(i*bins),1)=repmat(names(i),bins,1);
end
namesCol = regexprep(namesCol,'\.xls','');
resultSummary = num2cell(vertcat(files{:}));
resultSummary(2:end+1,7:end+6) = resultSummary;
resultSummary(1,:) = [{'name','mat','irrdT1','irrdDpa1','irrdT2','irrdDpa2'} dataHeaders strcat(dataHeaders(2:end),'STDV')];
resultSummary(2:end,1) = namesCol;
% Andy's stuff
% renaming some data
%resultSummary(strcmp(resultSummary(:,1),'B010Control'),1) = {'B010b'};
resultSummary(strcmp(resultSummary(:,1),'B010H_edited'),1) = {'B010H'};
%resultSummary(strcmp(resultSummary(:,1),'C2_I'),1) = {'C2'};
%resultSummary(strcmp(resultSummary(:,1),'C2_U'),1) = {'Cr'};
resultSummary(strcmp(resultSummary(:,1),'B3U'),1) = {'B3_U'};
% add a 'material type' column
%resultSummary(:,3:end+1)=resultSummary(:,2:end);
resultSummary(strncmp(resultSummary(:,1),'A',1),2) = {'FeY'};
resultSummary(strncmp(resultSummary(:,1),'B',1),2) = {'FeYTi'};
resultSummary(strncmp(resultSummary(:,1),'C',1),2) = {'FeCrYTi'};
resultSummary(strcmp(resultSummary(:,1),'FeYTi'),2) = {'FeYTi'};
resultSummary(strcmp(resultSummary(:,1),'FeCrTiY'),2) = {'FeCrYTi'};

% other more fiddling
% dd2 is from matcodeConvert.csv
dd2 = {'A1','FeY',773,150,0,0;'B010','FeTiY',130,100,0,0;'B01010','FeTiY',117,100,973,100;'B010H','FeTiY',117,100,973,0;'B05','FeTiY',120,50,0,0;'B0510','FeTiY',120,50,973,100;'B05H','FeTiY',120,50,973,0;'B1','FeTiY',773,150,0,0;'B1u','FeTiY',773,0,0,0;'B2','FeTiY',973,150,0,0;'B2u','FeTiY',973,0,0,0;'B3','FeTiY',873,150,0,0;'B3_U','FeTiY',873,0,0,0;'C010','FeCrTiY',150,100,0,0;'C01010','FeCrTiY',119,100,973,100;'C010H','FeCrTiY',119,100,973,0;'C0510','FeCrTiY',118,50,973,100;'C05','FeCrTiY',118,50,0,0;'C05H','FeCrTiY',118,50,973,0;'C1','FeCrTiY',773,150,0,0;'C1u','FeCrTiY',773,0,0,0;'C2','FeCrTiY',973,150,0,0;'C2u','FeCrTiY',973,0,0,0;'C3','FeCrTiY',873,150,0,0;'C3u','FeCrTiY',873,0,0,0;'FeCrTiY','FeCrTiY',0,0,0,0;'FeTiY','FeTiY',0,0,0,0;'Yex','FeY',0,0,0,0;'Yhi','FeY-hi',0,0,0,0;};
resultSummary = resultSummary(~strcmp('A1u_inner',resultSummary(:,1)),:);
resultSummary = resultSummary(~strcmp('A1u_outer',resultSummary(:,1)),:);
resultSummary = resultSummary(~strcmp('B010Control',resultSummary(:,1)),:);
resultSummary = resultSummary(~strcmp('C2_I',resultSummary(:,1)),:);
resultSummary = resultSummary(~strcmp('C2_U',resultSummary(:,1)),:);
resultSummary(strcmp('C2u_tagged',resultSummary(:,1)),1) = {'C2u'};
resultSummary(strcmp('FeYTi',resultSummary(:,1)),1) = {'FeTiY'};
resultSummary(strcmp('FeCrYTi',resultSummary(:,1)),1) = {'FeCrTiY'};
% add irrdT1 etc columnes
for i=2:size(resultSummary,1)
resultSummary(i,3:6) = dd2(strcmp(resultSummary{i,1} , dd2(:,1)),3:6);
end
resultSummary(strcmp('FeCrYTi',resultSummary(:,2)),2) = {'FeCrTiY'};
%cell2csv('nanoIndenterDataCoarse.csv',resultSummary);