% import nanoindenter xls data
% get file names
% open all the files in one folder
rootFolder = 'C:\Users\andy\Documents\indents\';
warning('off','MATLAB:xlsread:RangeIncompatible');
bins = 100;
dataHeaders = {'Displacement','Load','Time','HarmonicContactStiffness','Hardness','Modulus'};
dataCols = length(dataHeaders);
xaxis = 1; % columns from file.xls[Sheet!Test 001]
yaxis = 5;
xlsMaxRow = 1040000;
names = dir([rootFolder '*.xls']);
names = {names.name}';
files = cell(length(names),1);
for i = 1:length(names)
   disp(names{i});
   % open file
   first = xlsread([rootFolder names{i}],1,'','basic');
   % this should get the first page including the summary
   % extract the number of tests from the summary
   numTests = size(first,1)-3;
   % tagged/missing data
   tagged = isnan(first(1:end-3,1));
   tests = cell(numTests,1);
   for j=numTests:-1:1
       if ~tagged(j)
           testStr = ['Test ',num2str(j,'%03.0f')];
           testStrTag = [testStr ' Tagged'];
           try
               tests{j}=xlsread([rootFolder names{i}],testStr,'','basic');
               tests{j} = tests{j}(:,2:end); % remove first column
           catch
               disp(testStrTag);
               tagged(j) = 1;
               %tests{j}=xlsread([rootFolder names{i}],testStrTag,'','basic');
           end
           % columns
           %Displacement       %Load       %Time       %HarmonicContactStiffness       %Hardness       %Modulus
       end
   end
   % digitise
   compact = vertcat(tests{~tagged});
   [~,xout]= hist(compact(:,1),bins);
   xout = [0 xout];
   [n,bin] = histc(compact(:,1),xout);
   files{i} = zeros(bins,dataCols*2-1);
   
   for j=1:bins
       files{i}(j,:) = [mean(compact(bin==j,:),1) std(compact(bin==j,2:end),1)];
   end
end
warning('on','MATLAB:xlsread:RangeIncompatible');
% summarise
namesCol = cell(length(names)*bins,1);
for i=1:length(names)
    namesCol(((i-1)*bins+1):(i*bins),1)=repmat(names(i),bins,1);
end
namesCol = regexprep(namesCol,'\.xls','');
resultSummary = num2cell(vertcat(files{:}));
resultSummary(2:end+1,2:end+1) = resultSummary;
resultSummary(1,:) = [{'name'} dataHeaders strcat(dataHeaders(2:end),'STDV')];
resultSummary(2:end,1) = namesCol;
% Andy's stuff
% renaming some data
resultSummary(strcmp(resultSummary(:,1),'B010Control'),1) = {'B010b'};
resultSummary(strcmp(resultSummary(:,1),'B010H_edited'),1) = {'B010H'};
resultSummary(strcmp(resultSummary(:,1),'C2_I'),1) = {'C2'};
resultSummary(strcmp(resultSummary(:,1),'C2_U'),1) = {'Cr'};
resultSummary(strcmp(resultSummary(:,1),'B3U'),1) = {'B3_U'};
% add a 'material type' column
resultSummary(:,3:end+1)=resultSummary(:,2:end);
resultSummary(strncmp(resultSummary(:,1),'B',1),2) = {'FeYTi'};
resultSummary(strncmp(resultSummary(:,1),'C',1),2) = {'FeCrYTi'};