function [ionNames,ions,chargeState] =  mz2ion(m,rangeTable, elements)
%[ionNames,ionRows] =  mz2ion(m,rangeTable, elements)
% Takes a list of mass/charge ratios + range table (double) and converts 
% them into the ionic natural names eg. 64.01 -> TiO
% You must provide a range table in the following format:
% rangeStart rangeEnd element1 element2 element3 etc.
% 1.0        2.0      1        0        0
% 16.01      16.31    1        1        0
% and a cell of elements, eg {'H','O', ...}
% Note that ions will be built in the order the elements are provided in
% the list, ie HO not OH in this case.
% ions: is the list as it is ordered with increasing m/z
% A London May 2014

% sort range table by m/z for speed
rangeTable=sortrows(rangeTable,1);
%ions = makeIon(rangeTable(:,3:end),elements); % old, no charge state
[chargeState,ions] = ranges2chargeState(rangeTable,elements,0);

ionNames = cell(length(m),1); % for storing data
for i = 1:length(m)
    for r=1:size(rangeTable,1)
        if (m(i) >= rangeTable(r,1)) && (m(i) <= rangeTable(r,2))
            ionNames(i) = ions(r);
            break % break out of range loop
        else
           ionNames{i} = 'unranged'; % range not found
        end
    end
end
end