% load epos file
init = 0; % set to 1 to run the first time, this chunk is slow
if init
%load('C:\Users\andy\APT\epos\R14_18357-v01_d.mat'); % dP, tof, xd, yd
%load('C:\Users\andy\APT\epos\R14_18357-v01_Vc.mat'); % x,y,z,m,vdc
% load('H:\APT\epos\R14_18357-v01_d.mat'); % dP, tof, xd, yd
% load('H:\APT\epos\R14_18357-v01_Vc.mat'); % x,y,z,m,vdc
%load('C:\Users\andy\APT\epos\R14_15065-v04_d.mat'); % dP, tof, xd, yd
%load('C:\Users\andy\APT\epos\R14_15065-v04_Vc.mat'); % x,y,z,m,vdc
%fileName = 'F:\APT\Bulk Oxides\R14_13198Y2TI2O7 4M\recons\33vnm\default\R14_13198-v01';
%fileName = 'C:\Users\andy\APT\epos\R14_19435-v01';
%fileName = 'D:\APT\RoundRobin\R15_00554\recons\recon-v01\default\R15_00554-v01';
%fileName = 'D:\APT\RoundRobin\R38_01732\recons\recon-v01\default\R38_01732-v01';
%fileName = 'H:\APT\epos\files\R14_14814-v03';
%fileName = 'C:\Users\andy\APT\epos\R14_14814-v03';
% pfile = 'C:\Users\andy\APT\R14_14814_FeYTi_ODS\recons\recon-v03\default\R14_14814-v03.pos';
% ifile = 'C:\Users\andy\APT\R14_14814_FeYTi_ODS\recons\recon-v03\default\R14_14814-v03.cluster.indexed.pos';
%fileName = 'F:\APT\Ingrid\R18_54364-Al2O3';
fileName = 'C:\Users\andy\APT\R14_17886\recons\recon-v02\default\R14_17886-v02.epos';
[x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos(fileName);

% cluster IDs (slow)
% [xp,yp,zp,~,~]=readpos(pfile);
% [xc,yc,zc,mc]=readpos(ifile);
% clusterIds = clusterIndex(xp,yp,zp,xc,yc,zc,mc);
% clusterIds = clusterIds(1:end-1); % remove last data point?
% clear xp yp zp xc yc zc mc
    
% [x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos(fileName);
%rangeFile = 'C:\Users\andy\APT\13198.rrng';
%rangeFile = 'C:\Users\andy\APT\19435.rrng';
%rangeFile = 'C:\Users\andy\APT\18357_80.rrng';
rangeFile = 'C:\Users\andy\APT\14814.rrng';
%rangeFile = 'C:\Users\andy\APT\15065_90.rrng';

%rangeFile = 'H:\APT\15065_90.rrng';
[~, ~, elements, ranges] = rangeReader (rangeFile);

% get ion names
disp('Making ion names');
[ionNames,ionsRow] = mz2ion(m,cell2mat(ranges(:,[1:2 5:end])),elements);
disp('Finding multiple hits');
multiHit = (dP==0);
p = (multiHit+[multiHit(2:end); 0])>0; % inc first hit
%d1 = [xd(p) yd(p) tof(p) dP(p) m(p)];
%c = cumsum(p).*p;
firstHits = find(p-multiHit);
% fix alising, convert from float to detector channels
disp('converting to channels');
[ux,~,ix] = unique(xd);
[uy,~,iy] = unique(yd);
xrange = min(xd):mean(diff(ux)):max(xd);
yrange = min(yd):mean(diff(uy)):max(yd);
xrange2 = (2*min(xd)):mean(diff(ux)):(2*max(xd));
yrange2 = (2*min(yd)):mean(diff(uy)):(2*max(yd));
end% instert end here
disp('Multiple %');
disp(100*sum(p)/length(p));
d = zeros(sum(p)-length(firstHits),5);
dn = cell(sum(p)-length(firstHits),2);
di = 1;
dii = 1;
for i = 1:length(firstHits)
    while (firstHits(i)+di)<=length(multiHit) && multiHit(firstHits(i)+di)
        d(dii,1) = xd(firstHits(i))-xd(firstHits(i)+di);
        d(dii,2) = yd(firstHits(i))-yd(firstHits(i)+di);
%        d(dii,1) = ix(firstHits(i))-ix(firstHits(i)+di);
%        d(dii,2) = iy(firstHits(i))-iy(firstHits(i)+di);
        d(dii,3) = tof(firstHits(i)+di)-tof(firstHits(i));
        d(dii,4) = firstHits(i);
        d(dii,5) = m(firstHits(i)+di);
        dn(dii,1) = ionNames(firstHits(i)); % first hit
        dn(dii,2) = ionNames(firstHits(i)+di); % this hit
        di = di+1;
        dii = dii + 1;
    end
    di = 1;
end

%% slice through delta TOF
%tofSlices = [0 3 5 8 12 15:5:40 100 260 500 Inf]; % ns
tofSlices = [0 3 5 15:5:40 100 260 500 Inf]; % ns
%tofSlices = [0 3 4 5 15 25 45 Inf];
%tofSlices = [0:5:500 Inf];
rangeTable = cell2mat(ranges(:,[1:2 5:end]));
[~,ionRangeNames,rangeIonNum] = rangeM(0,rangeTable,elements);
% initialise composition table, ion names as rows (ionNames), cols = TOF
% slices
compList = zeros(length(ionRangeNames),length(tofSlices));
% get counts per range
%[rangeCounts] = massQuant(m(firstHits),rangeTable);
[rcounts]=rangeCounterSimple(m(firstHits),rangeTable);
rangeCounts = cell2mat(rcounts(:,3));
% save ionic composition
compList(:,1) = sum(full(sparse(1:length(rangeIonNum), rangeIonNum, rangeCounts)),1); % first hit mass

if 1
    for i = 1:(length(tofSlices)-1)
        subd = d(d(:,3)>tofSlices(i) & d(:,3)<tofSlices(i+1),:);
        %[uxd,~,ixd] = unique(subd(:,1));
        %[uyd,~,iyd] = unique(subd(:,2));
        [n]=hist3(subd(:,1:2),{xrange2,yrange2});imagesc(yrange2,xrange2,n); axis equal; xlim([-3 3]); ylim([-3 3]);
        imName = ['TOF slice ' num2str(tofSlices(i)) ' to ' num2str(tofSlices(i+1)) ' ns'];
        title(imName);
        hold on; plot(0,0,'w+'); hold off % plot centre cross
        saveas(gcf,[imName '.png']);
        % composition of this tof slice
        %[rangeCounts] = massQuant(subd(:,5),rangeTable);
        [rcounts]=rangeCounterSimple(subd(:,5),rangeTable);
        rangeCounts = cell2mat(rcounts(:,3));
        compList(:,i+1) = sum(full(sparse(1:length(rangeIonNum), rangeIonNum, rangeCounts)),1);
        dd = sqrt(subd(:,1).^2+subd(:,2).^2);
        [n,xout]=hist(dd,0:0.05:20);
        plot(xout,n); xlabel('Distance mm'); ylabel('Count');
        title(imName);
        saveas(gcf,['TOF-hist-' imName '.png']);
    end
end
%% Composition per slice
comp2 = 100*compList./repmat(sum(compList,1),size(compList,1),1);
ttext = cell(1,length(tofSlices)-1);
for i = 1:(length(tofSlices)-1)
ttext{i} = [ num2str(tofSlices(i)) ' to ' num2str(tofSlices(i+1))];
end
comp3 = cell(size(comp2)+1);
comp3(1,:) = [{'Ion','First Hit'} ttext];
comp3(2:end,:) = [ionRangeNames num2cell(comp2)];

%% 2D histograms
% multiples
figure
subd = d(d(:,3)>25,:); % exclude data < 25 ns
[n]=hist3(subd(:,1:2),{xrange2,yrange2});imagesc(xrange2,yrange2,n'); axis equal; xlim([-3 3]); ylim([-3 3]);set(gca,'YDir','normal')
cmap = colormap('jet');
cmap(1,:) = 1;
colormap(cmap);
caxis([0 max(n(:))]);
title('Multiples','FontSize',14);
xlabel('\Delta X_D','FontSize',14);
ylabel('\Delta Y_D','FontSize',14);
set(gca,'Position',[0.1300    0.1247    0.7750    0.8003]);
% export 2.5 by 2.5" eps figure
% singles
figure
s=[diff(xd(~multiHit)) diff(yd(~multiHit))];
[n]=hist3(s(:,1:2),{xrange2,yrange2});imagesc(xrange2,yrange2,n'); axis equal; xlim([-3 3]); ylim([-3 3]);set(gca,'YDir','normal')
cmap = colormap('jet');
cmap(1,:) = 1;
colormap(cmap);
caxis([0 max(n(:))]);
title('Singles','FontSize',14);
xlabel('\Delta X_D','FontSize',14);
ylabel('\Delta Y_D','FontSize',14);
set(gca,'Position',[0.1300    0.1247    0.7750    0.8003]);
%% normalised histograms:
figure
xout = 0:0.05:20.05;
% singles:
xy = [xd(~p) yd(~p)];
s = diff(xy,1,1);
dd = sqrt(s(:,1).^2+s(:,2).^2);
[n_singles]=hist(dd,xout);
% shuffle
shuffledSingles = xy(randperm(size(xy,1)),:);
ss = diff(shuffledSingles,1,1);
dd = sqrt(ss(:,1).^2+ss(:,2).^2);
[n_singles_shuf]=hist(dd,xout);
% multiples (all)
dd = sqrt(d(:,1).^2+d(:,2).^2);
[n_multi]=hist(dd,xout);
% shuffle
xym = [xd(p) yd(p)];
shuffledSingles = xym(randperm(size(xym,1)),:);
sm = diff(shuffledSingles,1);
dd = sqrt(sm(:,1).^2+sm(:,2).^2);
[n_multi_shuf]=hist(dd,xout);
% Plot
semilogy(xout(1:end-1),n_singles(1:end-1)./n_singles_shuf(1:end-1),xout(1:end-1),n_multi(1:end-1)./n_multi_shuf(1:end-1));
legend('Singles','Multiples');

%% difference between in cluster and out of cluster ions
% figure
% xout = 0:0.05:20.05;
% % out of cluster
% [n_cIn,n_cInRaw,xout]=multiHitHist1D([xd(clusterIds>0) yd(clusterIds>0)],xout);
% % in cluster
% [n_cOut,n_cOutRaw,xout]=multiHitHist1D([xd(clusterIds==0) yd(clusterIds==0)],xout);
% plot(xout(1:end-1),n_cIn(1:end-1),xout(1:end-1),n_cOut(1:end-1));
% legend('Clustered','Matrix');


%% singles distance composition difference
dd = sqrt(s(:,1).^2+s(:,2).^2);
dist_cutoff = 1;
[rcounts]=rangeCounterSimple(m(logical([dd<dist_cutoff; 0])),rangeTable);
rangeCounts = cell2mat(rcounts(:,3));
c_lessThan = sum(full(sparse(1:length(rangeIonNum), rangeIonNum, rangeCounts)),1);
[rcounts]=rangeCounterSimple(m(logical([dd>dist_cutoff; 0])),rangeTable);
rangeCounts = cell2mat(rcounts(:,3));
c_moreThan = sum(full(sparse(1:length(rangeIonNum), rangeIonNum, rangeCounts)),1);
c_single = [c_lessThan' c_moreThan'];
singlesDist = [ionRangeNames num2cell(100*c_single./repmat(sum(c_single,1),size(c_single,1),1))]
beep
%% detector map:
% [ux,~,ix] = unique(xd);
% [uy,~,iy] = unique(yd);
% (n=hist3([ix iy],[length(ux),length(uy)]);imagesc(n); axis equal) % old
% n=hist3([xd yd],{xrange,yrange});imagesc(xrange,yrange,n); axis equal;
% xlim([xrange(1) xrange(end)]); ylim([yrange(1) yrange(end)]);
% title('run number?')

%% multiple/singles histogram:
% [nm,xoutm]=hist(m(p),10000);
% [n,xout]=hist(m(~p),10000);
% semilogy(xout,n,xoutm,nm);legend('Singles','Multiples');
% xlabel('Mass/Charge Da');ylabel('Counts');

%% Plot histogram of ionic composition
% [ys,cs]=cellhist(ionNames(~p));
% [ym,cm]=cellhist(ionNames(p));
% [c,csi]=sort(cs);
% [c,cmi]=sort(cm);
% bar([ys(csi) ym(cmi)],'stacked');
% set(gca,'XTick',1:length(c));
% set(gca,'XTickLabel',c);