% load epos file
%load('C:\Users\andy\APT\epos\R14_15065-v04_d.mat'); % dP, tof, xd, yd
%load('C:\Users\andy\APT\epos\R14_15065-v04_Vc.mat'); % dP, tof, xd, yd
mp = m>27.9 & m<28.1;
xd2 = xd(mp);
yd2 = yd(mp);
tof2 = tof(mp);
dP2 = dP(mp);
multiHit = (dP2==0);
p = (multiHit+[multiHit(2:end); 0])>0; % inc first hit
%c = cumsum(p).*p;
firstHits = find(p-multiHit);

% fix alising
[ux,~,ix] = unique(xd);
[uy,~,iy] = unique(yd);

d = zeros(sum(p)-length(firstHits),4);
di = 1;
dii = 1;
for i = 1:length(firstHits)
    while multiHit(firstHits(i)+di)
        d(dii,1) = xd2(firstHits(i))-xd2(firstHits(i)+di);
        d(dii,2) = yd2(firstHits(i))-yd2(firstHits(i)+di);
%        d(dii,1) = ix(firstHits(i))-ix(firstHits(i)+di);
%        d(dii,2) = iy(firstHits(i))-iy(firstHits(i)+di);
        d(dii,3) = tof2(firstHits(i)+di)-tof2(firstHits(i));
        d(dii,4) = firstHits(i);
        di = di+1;
        dii = dii + 1;
    end
    di = 1;
end

% slice through delta TOF
tofSlices = [0:2:40 60:40:260]; % ns
for i = 1:(length(tofSlices)-1)
    subd = d(d(:,3)>tofSlices(i) & d(:,3)<tofSlices(i+1),:);
    [uxd,~,ixd] = unique(subd(:,1));
    [uyd,~,iyd] = unique(subd(:,2));
    [n]=hist3(subd(:,1:2),[2200,2200]);imagesc(uyd,uxd,n); axis equal; xlim([-3 3]); ylim([-3 3]);
    imName = ['TOF slice ' num2str(tofSlices(i)) ' to ' num2str(tofSlices(i+1)) ' ns'];
    title(imName);
    saveas(gcf,[imName '.png']);
end

%% detector map:
% [ux,~,ix] = unique(xd);
% [uy,~,iy] = unique(yd);
% n=hist3([ix iy],[length(ux),length(uy)]);imagesc(n); axis equal