% multiple hit simulator
% open a pos file
% make a probability distribution
% pick a first hit
% pick a second hit
% store simulated multiples' spectrum

for i = 0
    if(0)
        % load masses
        %filename = '';
        % [x,y,z,masses]=readpos(filename);
        % load('C:\Users\andy\APT\R14_18973\recons\recon-v05\default\R14_18973-v05.matrix_m.mat');
        %
        % [yb,xb] = stairs(masses); % remove duplicates
        % xb = xb(1:2:end);
        % yb = yb(1:2:end);
        
        hits = 10000000;
        h1 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
        h2 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
        dtof = abs(h1-h2);
        
        [y,x]=hist(dtof,5000);
        %semilogy(x,y)
        % make background
        hits2=700000;
        dtof2 = abs((rand(hits2,1)*270)-(rand(hits2,1)*270));
        [y2,x2]=hist(dtof2,100);semilogy(x,y,'k-',x2,y2*(19/9200),'r-')
        
        xlim([0 60.8211995607043]);
        ylim([1 10000000]);
    end
end
%% using multi-hit data:
init=0;
if init
    load('C:\Users\andy\APT\epos\R14_15065-v04_d.mat');
    load('C:\Users\andy\APT\epos\R14_15065-v04_Vc.mat');
    multiHit = (dP==0);
    p = (multiHit+[multiHit(2:end); 0])>0; % inc first hit
    firstHits = find(p-multiHit);
    dtof = tof(firstHits+1)-tof(firstHits);
    dm = m(firstHits+1)-m(firstHits);
end
[y,x]=hist(dm,40000); % actual delta mass data

hits = sum(y)*100; % normalisation
[yb,xb] = stairs(sort(m(multiHit))); % remove duplicates
xb = xb(1:2:end);
yb = yb(1:2:end);
h1 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
h2 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
dmSimM = abs(h1-h2); % "simulated" delta masses from multi-hit data
[ysimM,xsimM]=hist(dmSimM,40000);
[ymM,xmM]=hist(h1,40000); 

[yb,xb] = stairs(sort(m)); % remove duplicates
xb = xb(1:2:end);
yb = yb(1:2:end);
h1 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
h2 = interp1(yb,xb,rand(hits,1)*max(yb),'linear');
dmSim = abs(h1-h2); % "simulated" delta masses from all data
[ysim,xsim]=hist(dmSim,40000);
[ym,xm]=hist(h1,40000); 

plot(x,y,xsim,ysim/100,xsimM,ysimM/100)
legend('Actual','all-sim','multiples-sim')

% Fe-peak counts
ranges = [26.9 27.86; ...
        27.86 28.42; ...
        28.42 28.91; ...
        28.91 29.06;];
[rangeCounts]=rangeCounterSimple(m(~multiHit),ranges);
[rangeCountsM]=rangeCounterSimple(m(multiHit),ranges);
