function [n,n_raw,xout]=multiHitHist1D(xy,xout)
%[n,xout]=multiHitHist1D(xy,xout)
% returns the normalised histogram of distances given a matrix n-by-2 of
% X,Y positions and the bins defined by xout
ss = diff(xy,1,1);
dd = sqrt(ss(:,1).^2+ss(:,2).^2);
[n_raw]=hist(dd,xout);
% out of cluster - shuffed
shuffled = xy(randperm(size(xy,1)),:);
ss = diff(shuffled,1,1);
dd = sqrt(ss(:,1).^2+ss(:,2).^2);
[n_shuf]=hist(dd,xout);
n = n_raw./n_shuf;
end