% load data
[d,cols]=dataBase('run>0',1);
cfRoot = 'C:\Users\andy\APT\clusterAnalysis\';
export = cell(size(d,1),1);
for i=1:size(d,1)
    id = {num2str(d{i,strcmp('run',cols)})};
    matCode = d(i,strcmp('matCode',cols));
    clusterDataFile = [cfRoot d{i,strcmp('cf',cols)}];
    [elements,countsDecomp,counts,position,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(clusterDataFile);
    ytio = countsDecomp(:,[find(strcmp(elements,'Y')) find(strcmp(elements,'Ti')) find(strcmp(elements,'O'))]);
    ytiof = countsDecomp(:,[find(strcmp(elements,'Y')) find(strcmp(elements,'Ti')) find(strcmp(elements,'O'))])./repmat(sum(ytio,2),1,3);
    export{i} = [repmat([id matCode],count,1) num2cell([rz*sqrt(5) ytiof(:,1)+ytiof(:,2)/2 ytiof(:,2)*sqrt(3/4) ytio sum(ytio,2)])];
end
export = [{'run','mat','r','x','y','Y','Ti','O','total'};vertcat(export{:})];
cell2csv('undecompTernData2015.csv',export);