function [p]=mle_solver2(n,C,p0)
%[pb,pc]=mle_solver(n,C,p0)
% n=[n1 n2 n3]
% C = how B and C ions partition into bins 1, 2 and 3, eg:
% C = [0.5 0; 0.5 0.9; 0 0.1]; col1 = B, col2 = C, rows = bins
% p0 = starting conditions (same number of cols as C), 1 row

% Example data:
%cB=0.2; cC=0.1;
%C = [0.5 0; 0.5 0.9; 0 0.1];
%N = 3000;
%n = mnrnd(3000,(C*[cB cC]')./sum([cB cC]))
%n=[1000 1900 100];
maxiters = 5000;
tol = 1E-6;
s = 0.001; % starting step to estimate gradient
L = @(n,C,p) -sum(log((p*C')).*repmat(n,size(p,1),1),2); % likelihood estimator
dif = Inf;
iter = 0;
p0(end) = 1-sum(p0(1:end-1));
while dif>tol && iter<=maxiters
    d=zeros(length(p0),1);
    for i=1:(length(p0)-1)
        p1 = p0;
        p1(i) = p0(i) - s;
        p1(end) = 1-sum(p1(1:end-1));
        d(i,1) = L(n,C,p0)-L(n,C,p1);
        p1(i) = p0(i) + s;
        p1(end) = 1-sum(p1(1:end-1));
        d(i,2) = L(n,C,p0)-L(n,C,p1);
    end
    dd = diff(d,1,2);
    p2 = p0 + (dd*s)';
    if sum(p2<0 | p2>0)
       p2(p2<0) = 0; % set negatives to 0
       p2(p2>1) = 1;
       p2(end) = 1-sum(p2); % set constraint
    end
    p0 = p2;
    p0(end) = 1-sum(p0(1:end-1));
    dif = sum(sqrt((dd*s).^2));
    iter = iter+1;
end
if iter == maxiters
    warning('MLE solver reached maximum iteration limit');
end
if sum(isnan(p0))
    warning('NaN detected, using lsqnonneg');
    p = lsqnonneg(C,n');
    p = p'./sum(p);
else
    p = p0;
end
end