function [pb,pc]=mle_solver(n,C)
%[pb,pc]=mle_solver(n,C)
% n=[n1 n2 n3]
% C = how B and C ions partition into bins 1, 2 and 3, eg:
% C = [0.5 0; 0.5 0.9; 0 0.1]; col1 = B, col2 = C, rows = bins
% Only works for a two component system at the moment
% Example data:
%cB=0.2; cC=0.1;
%C = [0.5 0; 0.5 0.9; 0 0.1];
%N = 3000;
%n = mnrnd(3000,(C*[cB cC]')./sum([cB cC]))
%n=[1000 1900 100];

% likely hood function:
%[x,y]=meshgrid(0.1:0.05:1,0.01:0.05:1);
dist = 1;
x = 0:0.05:1;
y=1-x;
p=[x(:) y(:)]; % trial p's
L = sum(log((p*C')).*repmat(n,size(p,1),1),2);
d=Inf;
steps = 1023;
tol = 1E-5;
while d>tol
    [L0,i]=max(L);
    xi = x(i);
    x = (xi-dist/2):(dist/steps):(xi+dist/2);
    x = x(x>0 & x<1);
    y=1-x;
    p=[x(:) y(:)]; % trial p's
    L = sum(log((p*C')).*repmat(n,size(p,1),1),2);
    [L1,i]=max(L);
    d = abs(L0-L1);
    dist = dist/steps;
end
pb = xi;
pc= 1-xi;
end