function y = mdlexp(a,x)
% a negative exponential fit for apt mass spectrum tails
%p(1) = noise floor
%p(2) = offset (peak position + 0.03)
%p(3) = decay const
%p(4) = amplitude
y = -a(4)*(x-a(2)).*exp(-(x-a(2))*a(3));
% remove positive values
for i=1:length(x)
    if(y(i)>0)
        y(i) = 0;
    end
end
% add noise floor
y = y + a(1);
end