% mass spectra summary
% loadmany data sets of the same material, sample them and plot them
num_bins = 200000;
% get data
[d,cols]=dataBase('run>0',1);
matCol = strcmp('mat',cols);
posFiles = strcat(d(:,strcmp('reconRoot',cols)),d(:,strcmp('pos',cols)));
rangeFiles = strcat('average_',{'FeCrTiY';'FeTiY';'FeY';'FeY-hi';},'.rrng');
% mass data cell
m = cell(length(posFiles),2); % {mass list, material}
% load files in turn
for i = 1:length(posFiles)
    fileInfo = dir(posFiles{i});
    fileSize = fileInfo.bytes;
    % load data samples
    [~,~,~,m1]=readpospart(posFiles{i},round(.02*(fileSize/16)),round(.04*(fileSize/16)));
    [~,~,~,m2]=readpospart(posFiles{i},round(.43*(fileSize/16)),round(.44*(fileSize/16)));
    [~,~,~,m3]=readpospart(posFiles{i},round(.85*(fileSize/16)),round(.86*(fileSize/16)));
    m(i,:) = {{[m1 m2 m3]} d{i,matCol}};
end
% plot spectra
tic
[u,ic,ia] = unique(m(:,2)); % unique list of materials
for i = 1:length(u)
   figure 
   a=vertcat(m{ia==i,1});
   [heights,centres]=hist(horzcat(a{:}),num_bins);
   h=bar(centres,heights,1);
   rangePlotter2(rangeFiles{i},h,heights, centres);
   toc
end