function [x,y]=massSpecSim(centres,heights,roi)
% returns a CDF (x,y) for the region of interest (roi=[lower upper]) of 
% the histogram defined by centres (c) and heights (h).
% A. London Feb 2014
bin = centres(3)-centres(2);
c = round((roi(1)-centres(1))/bin);
d = round((roi(2)-centres(1))/bin);
y = heights(:,c:d)-min(heights(:,c:d)); % y
x = centres(:,c:d);    % x
y = cumsum(y); % discrete cumulative dist
y = y./max(y); % normalise between 0 and 1
% remove duplicates
[~,ia,~] = unique(y,'stable');
x = x(ia);
y = y(ia);
end