function [decompCounts] = massQuantEle(massList,rangeTable)
% [counts] = massQuant(massList,rangeTable)
% Takes a list of masses and a range table (like that produced by
% rangeReader and returns the counts of those masses in each range (ionic)
% and the decomposed counts (elemental)
% The range table should be formatted like this:
% 1          2        (3)   (4)      5            4+element_num
% rangeStart rangeEnd (vol) (colour) element1 ... elementN
% ***WITH COLUMNS 3 AND 4 MISSING AND ALL AS SINGLE/DOUBLE FLOATS***
% Where element1 is the number of elements in that ion in that range
% A London June 2013
decompCounts = zeros(1,length(rangeTable(1,3:end)));

for r=1:length(rangeTable(:,1)) 
    q = sum((massList >= rangeTable(r,1)) & (massList <= rangeTable(r,2)));
    decompCounts = decompCounts + rangeTable(r,3:end)*q;
end
end