function [rangeCounts,decompCounts] = massQuant(massList,rangeTable)
% [rangeCounts,decompCounts] = massQuant(massList,rangeTable)
% Takes a list of masses and a range table (like that produced by
% rangeReader and returns the counts of those masses in each range (ionic)
% and the decomposed counts (elemental)
% The range table should be formatted like this:
% 1          2        (3)   (4)      5            4+element_num
% rangeStart rangeEnd (vol) (colour) element1 ... elementN
% ***WITH COLUMNS 3 AND 4 MISSING AND ALL AS SINGLE/DOUBLE FLOATS***
% Where element1 is the number of elements in that ion in that range
% A London June 2013
counts = zeros(size(rangeTable)-[0 2]);

for r=1:length(rangeTable(:,1)) 
    q = sum((massList >= rangeTable(r,1)) & (massList <= rangeTable(r,2)));
    counts(r,:) = rangeTable(r,3:end)*q;
end
% decompose counts:
decompCounts = sum(counts,1);
rangeCounts = (sum(counts,2)./(sum(rangeTable(:,3:end),2)))';
end