% mass=spectra fitting
%% load reference spectra
bin = 0.001;
maxm = 200;
load('C:\Users\andy\APT\R14_15868 Cr02\recons\recon-v01\default\R14_15868-v01.matrix_m.mat');
x0=0:bin:(maxm+bin);
y = hist(masses,x0);
% remove over/underflow bins
x = x0(2:end-1);
matrix = y(2:end-1);
load('C:\Users\andy\APT\R14_15868 Cr02\recons\recon-v01\default\R14_15868-v01.cluster_m.mat');
y = hist(masses,x0);
% remove over/underflow bins
cluster = y(2:end-1);
load('Y2Ti2O7_m.mat');
y = hist(masses,x0);
% remove over/underflow bins
y227 = y(2:end-1);
load('Y2TiO5_m.mat');
y = hist(masses,x0);
% remove over/underflow bins
y215 = y(2:end-1);
% Ti-free material
m=readpos_mass('C:\Users\andy\APT\R14_15645 YEx04\recons\recon-v01\default\R14_15645-v01.cluster.pos');
y = hist(m,x0);
% remove over/underflow bins
yEx = y(2:end-1);
%% plotting
semilogy(x,matrix,x,cluster,x,y227,x,y215,x,yEx);
legend('m','c','227','215');

%% generate possible cluster profile by simulating hits based on the 227
% mass spectrum:
% crop to area of interest
%roi = [77.82 82.59];
roi = [30.94 33.13];
c = round((roi(1)-x(1))/bin);
d = round((roi(2)-x(1))/bin);
[data(1,:),data(2,:)]=massSpecSim(x,y227,roi);
[data2(1,:),data2(2,:)]=massSpecSim(x,y215,roi);
% plot reference curve
plot(x(c:d),cluster(c:d))
% generate random data from y227
% how many total hits? = sum(cluster(c:d))
m = interp1(data(2,:),data(1,:),rand(sum(cluster(c:d))-min(cluster(c:d)),1),'linear');
m2 = interp1(data2(2,:),data2(1,:),rand(sum(cluster(c:d))-min(cluster(c:d)),1),'linear');
% generate histogram of simulated spectrum
t227 = hist(m,x0);
t227 = t227(2:end-1); % crop
t215 = hist(m2,x0);
t215 = t215(2:end-1); % crop
plot(x(c:d),cluster(c:d)-min(cluster(c:d)),x(c:d),t227(c:d),x(c:d),t215(c:d),x(c:d),yEx(c:d));
legend('cluster','227','215','YEx');
xlabel('Mass/charge amu');
ylabel('Counts');
hold on
plot([31.971435 31.971435],[0 700])
plot([31.98984 31.98984],[0 700])
hold off
xlim(roi);