function [deconvCounts,asRangedCounts,rangeOutput,rangeTableDecomp]=massDecomp(rangeFile,posFile,overlaps)
%[deconvCounts,asRangedCounts,rangeOutput]=massDecomp(rangeFileList,posFileList,overlaps)
% Takes a rrng file, pos files and a definition of the overlapping ions and
% returns the atomic deconvolved counts per pos file (cols are the elements
% in rangeElements)
% A London Oct 2013
%% Initialise vars
%posFile = regexprep(posFile,'.pos','');

%% Read rrng file
[element_num, range_num, rangeOutput, ranges] = rangeReader(rangeFile);
% for the mass list counting:
rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix

%% Peak overlap stuff
% For peak deconvolution
overlapY = cell(size(overlaps));
overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data

overlap_num = length(overlaps);
for o = 1:overlap_num
    overlapY{o} = peakHeights(overlaps{o}); % range v ion
    overlapTable{o} = ions2ionTable(overlaps{o},rangeOutput); % ion v element
end
%% Read files
m =loadMasses(posFile);
rangeTableDecomp = rangeTable; % rangeTable for this posfile
% get mass spectrum of this pos file
%[rangeCounts,asRangedCounts] = massQuant(m,rangeTable); % old
% noise corrected:
[rangeCounts]=rangeCounterSimple(m,rangeTable);
rangeCounts = cell2mat(rangeCounts(:,3))';
asRangedCounts = rangeCounts*rangeTable(:,3:end);
%% Loop through overlaps
for o = 1:overlap_num
    % get ionicRangePercentages
    [ionicRangeComp,failedIons] = peakDecompFail(m,overlapY{o});
%     peakDecompPlot2(m,overlapY{o},overlaps{o});
%     pause
    ionStatus = failedIons;
    % get for errors
    while sum(failedIons)>0 && length(failedIons)>1
        disp(strcat('Removing ion:',num2str(find(ionStatus)),':', ions2ionStrChrg(overlaps{o}(ionStatus)) ));
        %[ionicRangeComp,failedIons] = peakDecompPlot(mp,overlapY{o}(:,logical([1 ~failedIons'])),overlaps{o}(~failedIons));
        [ionicRangeComp,failedIons] = peakDecompFail(m,overlapY{o}(:,logical([1 ~ionStatus'])));
%         peakDecompPlot2(m,overlapY{o},overlaps{o}(logical([1 ~ionStatus'])));
%         pause
        ionStatus(ionStatus==0)=failedIons; % update ion status
    end
    % detect failure
    if sum(ionicRangeComp(:)) == 0 || sum(isnan(ionicRangeComp(:)))
        % do not change compTable or copy into rangeTable
        disp('Could not decompose this pos file`s overlaps');
        rangeTableDecomp = rangeTable; % reset for this cluster
        break
    else
        % find the appropriate ranges
        compTable = ionicRangeComp * overlapTable{o}(logical(~ionStatus'),:);
        for t = 1:length(overlapY{o}(:,1))
            tr = overlapY{o}(t,1);
            yr = find(tr>rangeTable(:,1) & tr<rangeTable(:,2)); % range to replace
            if length(yr)>1
                error(strcat('Range overlap detected at ',num2str(tr),' with ranges:',num2str(yr)));
            elseif isempty(yr)
                disp(strcat('No range containing ', num2str(tr), ' found'));
            else
                % copy in the row from the matrix of ionic percentages v elements
                rangeTableDecomp(yr,3:end) = compTable(t,:);
            end
        end
    end
end
% check resulting ionic range table:
missingElements = find(sum(rangeTableDecomp(:,3:end),2)<0.95);
if ~isempty(missingElements)
   warning(strcat('No element for range:',num2str(rangeTableDecomp(missingElements,1),4)));
   % use original range table entry
   rangeTableDecomp(missingElements,:) = rangeTable(missingElements,:);
end
% ready to do the new decomp
deconvCounts = rangeCounts*(rangeTableDecomp(:,3:end));
end