% Generate a pos file for checking a cluster search
% Use bcc iron (all hard coded)

% Size in nm
edgeSize = 50; % nm
a = 0.2866; % plane spacing in nm
fileName = 'fe.pos';
realisticMasses = 1; % set to one to use real mass data
numClusters = 20; % / (edgeSize nm)^3
clusterRadius = 0.5; % nm
clusterVar = 0;
clusterMassVar = 0.1;
clusterDensity = 150; % ions per nm^3 in the cluster

if(realisticMasses) % realisitic masses
    if(~exist('feMass.mat','file'))
        disp('Getting real mass values');
        % get a probablility distribution from a mass spectrum:
        % read a file
        [~,heights,centres] = rangePlotter('C:\Users\andy\APT\15576.rrng','C:\Users\andy\APT\R14_15576 YEx03\recons\recon-v01\default\R14_15576-v01.pos',200000);
        bw = centres(2)-centres(1); % bin width
        % crop to area of interest
        c = round((26.92-centres(1))/bw);
        d = round((29.58-centres(1))/bw);
        data(2,:) = heights(:,c:d); % y
        data(1,:) = centres(:,c:d); % x
        data(2,:) = cumsum(data(2,:)); % discrete cumulative dist
        %data = unique(data,'rows'); % remove possible duplicates
        data(2,:) = data(2,:)./max(data(2,:)); % normalise between 0 and 1
        % now use:
        % interp1(datac(2,:),datac(1,:),rand(10000,1),'linear')
        % to generate eg 10,000 samples from this data set. Magic!
        disp('Saving masses');
        save('feMass.mat','data');
    else
        load('feMass.mat');
    end
else
    data(2,1:3) = [0, 0.5, 1];
    data(1,1:3) = 27;
end

% Generate a bcc iron matrix
% total size of array:
edgeAtomNum = floor(edgeSize/a);
atomNum = 2*(edgeAtomNum^3);
% x mod edge to get repeating rows, + 1/2 for odd layers
disp('Generating x...');
x = mod(0:(atomNum-1),edgeAtomNum) + mod(floor((0:(atomNum-1))./(edgeAtomNum^2)),2)*0.5;
disp('Generating y...');
y = mod(floor((0:(atomNum-1))./edgeAtomNum),edgeAtomNum)+ mod(floor((0:(atomNum-1))./(edgeAtomNum^2)),2)*0.5;
disp('Generating z...');
z = floor((0:(atomNum-1))./(edgeAtomNum^2))/2;

% scale into nm from lattice vectors
x = x * a;
y = y * a;
z = z * a;

% generate mass values
disp('Generating m...');
m = interp1(data(2,:),data(1,:),rand(atomNum,1),'linear');

% clusters
% random spherically distributed points
if(numClusters)
    xt = []; % test vars
    yt = xt;
    zt = xt;
    mt = xt;
    % distribute spatially avoiding the edges
    clusters(:,1) = clusterRadius + rand(numClusters,1)*(edgeSize-2*clusterRadius);
    clusters(:,2) = clusterRadius + rand(numClusters,1)*(edgeSize-2*clusterRadius);
    clusters(:,3) = clusterRadius + rand(numClusters,1)*(edgeSize-2*clusterRadius);
    if(clusterVar)
        clusters(:,4) = clusterRadius + clusterVar*randn(numClusters);
    else
        % fixed cluster radius
        clusters(:,4) = clusterRadius;
    end
    
    % Y     10
    % YO	10
    % TiO	10
    % O     30
    % Fe	180
    
    ionMasses = [29.5, 104.9, 32, 16, 27];
    probs = [10,10,10,30,180];
    probc = cumsum(probs);
    for c = 1:length(clusters)
        vol = (4/3)*pi*clusters(c,4)^3;
        [xc,yc,zc] = randsphere(vol*clusterDensity,clusters(c,4));
        mr = rand(round(vol*clusterDensity))*probc(end);
        mc = zeros(length(mr),1);
        % convert random numbers into masses
        for i = 1:length(mr)
            for j = 1:length(probc)
                if(j==1)
                    if(mr(i)<probc(1))
                        mc(i) = ionMasses(j)+clusterMassVar*randn;
                        break
                    end
                elseif (j<length(probc))
                    if(mr(i)<probc(j))
                        if(mr(i)>=probc(j-1))
                            mc(i) = ionMasses(j)+clusterMassVar*randn;
                            break
                        end
                    end
                else
                    % else pick an iron mass
                    mc(i) = interp1(data(2,:),data(1,:),rand,'linear');
                end
            end
        end
        % add on the coords and masses to x,y,z,m
        xt = [xt; (xc + clusters(c,1))];
        yt = [yt; (yc + clusters(c,2))];
        zt = [zt; (zc + clusters(c,3))];
        mt = [mt; mc];
        % remove exisiting iron from the clusters
        % ... TODO
        
    end
    % add the new data to x,y,z,m
    % ...TODO
end

% Uncomment TODO
%disp(strcat('Saving pos file:',fileName));
%savepos(x,y,z,m,fileName);


