% LyX figure location change
% change figures from absolute to relative references and copy them to the
% correct location

lyxFiles = {'C:\Users\andy\Dropbox\lyx\5High-Temperature Irradiation.lyx';};
searchFor = '\\begin_inset Graphics';
newRoot = 'images/'; % where images will be moved to
root = 'C:/Users/andy/Dropbox/lyx/'; % where newRoot folder exists
replace = {'\.\.\/','C:/users/andy/dropbox/'}; % for back referenced folders
excmpt = 'figure'; % do not move figures in this folder already
excmpt2 = 'images'; 
newFiles = cell(size(lyxFiles));
for i = 1:length(lyxFiles)
    % get number of files of orignal file:
    n = 0;
    fid = fopen(lyxFiles{i});
    s = fgets(fid,1);
    while ischar(s)
        n = n + 1;
        s = fgets(fid,1);
    end
    fclose(fid);
    
    newFiles{i} = cell(n,1); % new file
    
    % read file
    n1 = 0;
    fid = fopen(lyxFiles{i});
    s = fgets(fid);
    while ischar(s)
        n1 = n1 + 1; % set index
        newFiles{i}{n1} = s;
        if regexp(s,searchFor)
            s = fgets(fid); % get next line
            n1 = n1 + 1; % set index
            newFiles{i}{n1} = s;
            [path,name,ext]=fileparts(regexprep(s,'filename|\n|\r|\s',''));
            % check for exemption:
            if ~strcmp(path,excmpt) && ~strcmp(path,excmpt2)
                % check for back referencing:
                path = regexprep(path,replace{1},replace{2});
                % copy file
                cpy([path '/' name ext], [root newRoot name ext]);
                % write new output
                newFiles{i}(n1) = {sprintf('%s\n\r',['	filename ' newRoot name ext])};
                disp(newFiles{i}(n1));
            end
        end
        s = fgets(fid);
    end
    fclose(fid);
    % write new LyX file
    fid = fopen([lyxFiles{i} '2'],'w');
    for j = 1:size(newFiles{i},1)
       fprintf(fid,'%s', newFiles{i}{j});
    end
    fclose(fid);
end