% per-atom deconvolution of overlapping peaks using a sphere around each
% atom
posFile = 'F:\APT\R14_17053\recons\recon-v01\default\R14_17053-v01.pos';
rangeFile = 'C:\users\andy\APT\ranges\17053ss_80.rrng';
sphereSize = 1; % deconv sphere size in nm
%% define overlaps
overlaps{1} = {{1,'C',2} {2,'Ti'}};
overlaps{2} = {{2,'Ti','O'} {1,'O',2}};
overlaps{3} = {{3,'Y','O'} {2,'Fe','N'}};
overlaps{4} = {{1,'Ti','O'} {2,'Fe',2,'O'} {1,'Fe','N'} {1,'Fe','O'}};
%% load pos file
[x,y,z,m,n]=readpos(posFile);
%% load ranges
[element_num, range_num, elements, ranges] = rangeReader(rangeFile);

%% Peak overlap stuff
% For peak deconvolution
overlapY = cell(size(overlaps));
overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data
overlapMaxIon = cell(size(overlaps)); % which ion in each overlap range has the max abund.
overlap_num = length(overlaps);
for o = 1:overlap_num
    overlapY{o} = peakHeights(overlaps{o});
    overlapTable{o} = ions2ionTable(overlaps{o},elements);
    [~,t] = max(overlapY{o}(:,2:end),[],2);
    overlapMaxIon{o} = t;
end
overlapMaxIon = vertcat(overlapMaxIon{:});
%% build ranges (add in any neceesary for the deconvolution)
% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)
s=cellfun(@(x) x(:,1),overlapY','uni',0);
overlapPeaks=vertcat(s{:});
overlapRanges = [overlapPeaks(:,1)-rs.*sqrt(overlapPeaks(:,1)) overlapPeaks(:,1)+rf.*sqrt(overlapPeaks(:,1))];

% are elements in overlaps in ranges?
[overlap_tab,overlap_elements]=ions2ionTable(horzcat(overlaps{:}));
[p,idx]=ismember(overlap_elements,elements);
if sum(~p)
    % some elements are missing
    % - add elements to ranges (columns)
    elements = [elements overlap_elements(~p)];
    ranges(:,end+1:(end+1+sum(~p))) = num2cell(zeros(size(ranges,1),sum(~p)));
end
% are all peaks ranged for the deconv?
% - add ranges to ranges (rows) [set colour and volume info?]
[p,idx]=ismemberRanges(overlapPeaks,cell2mat(ranges(:,[1 2 5:end])));
if sum(~p)
    % make new ranges from overlaps and overlapRanges
    a=cellfun(@size,overlapY,'uni',0)'; % which overlap ranges have which ions?
    a=vertcat(a{:});
    a(:,2) = a(:,2)-1;
    overlap_ion_tab = zeros(size(overlapRanges,1),1);
    ca = cumsum(a,1);
    for j = 1:length(overlap_ion_tab)
        idx = ca(:,1)-j;
        idx(idx<0) = idx(idx<0)+inf;
        idx = find(idx==min(idx));
        %overlap_ion_tab{j} = (ca(idx,2)-a(idx,2)+1):ca(idx,2);
        overlap_ion_tab(j) = overlapMaxIon(j)+ca(idx,2)-a(idx,2);
    end
    [overlap_tab]=ions2ionTable(horzcat(overlaps{:}),elements);
    % need to dupe overlap_tab and match up with overlapRanges
    newRanges = [num2cell(overlapRanges) num2cell(zeros(size(overlapRanges,1),1)) repmat({'000000'},size(overlapRanges,1),1) num2cell(overlap_tab(overlap_ion_tab,:))];
    ranges = [ranges; newRanges(~p,:)];
end
% ignore non-overlapped data for now
[p,idx]=ismemberRanges(overlapPeaks,cell2mat(ranges(:,[1 2 5:end])));
ranges_double = cell2mat(ranges(idx,[1 2 5:end])); % sub-set of ranges only containing peaks required for resolving overlaps
m_ranged = isranged1(m,ranges_double); % logical list of which ions are "ranged"
m2 = m(m_ranged); % ranged masses only
%% grow KD tree
%X = [x' y' z']; % might not need all the ions, just the ones before & after the overlap regions
X2 = [x(m_ranged)' y(m_ranged)' z(m_ranged)'];
Mdl = KDTreeSearcher(X2);
[idx,~]=rangesearch(Mdl,X2,sphereSize); % find surrounding atoms
%% loop over each atom
count = length(X2);
for c = 1:count
    mp = m2(idx{c});
    % deconv based on local ranged counts
    for o = 1:overlap_num
        [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o});
        ionStatus = failedIons;
        % get for errors
        if sum(failedIons)>0
            disp(strcat('Removing ion:',num2str(find(failedIons))));
            [ionicRangeComp,failedIons] = peakDecompFail(mp,overlapY{o}(:,logical([1 ~failedIons'])));
        end
    end
    % do something with ionicRangeComp
    % store ionic composition
    % randomly assign new identity
end