function [masses] = loadMasses(posFile)
%This function loads masses from a posfile or loads a cached masses
%result, if no cache is found a new _m.mat masses file is writen.
posFileM = strcat(regexprep(posFile,'\.pos',''),'_m.mat');
% check for cached masses
if(exist(posFileM,'file'))
    % load masses from a file
    % using .m as it is compressed compared to .txt
    disp(strcat('Loading cached masses:',posFileM));
    load(posFileM,'masses');
else
    if exist(strcat(posFile,'.pos'),'file')
        % open pos file and store masses
        disp('Open pos file');
        masses = readpos_mass(posFile);
        % save the masses for next time
        disp(strcat('Saving cached masses:',posFileM));
        save(posFileM,'masses');
    elseif exist(posFile,'file')
        % open pos file and store masses
        disp('Open pos file');
        masses = readpos_mass(posFile);
        % save the masses for next time
        disp(strcat('Saving cached masses:',posFileM));
        save(posFileM,'masses');
    else
        error(strcat('pos file:',posFile,' not found!'));
    end
end
end