% Decompose overlaps in blocks of ions taken parallel to the analysis
% direction.

binwidth = 1; % nm along z
% overlaps = {{{2,'Ti','O'},{1,'O',2}}};
% fileName = '15868_c86.pos';
% rrngFile = 'average_FeCrTiY.rrng';
overlaps = {{{1,'In'},{1,'Cd'}},{{1,'Cu'},{1,'Cu','H'},{1,'S',2},{1,'S',2,'H'}},{{1,'Cd','S'},{1,'Cu','Se'}}};
fileName = 'C:\Users\andy\Documents\NetBeansProjects\R25_12638-pos\recons\Recon\R25_12638-v01-roi\R25_12638-v01-roi.pos';
rrngFile = 'F:\APT\Oana\M8-dot.rrng';
%% read data
[element_num, range_num, rangeElements, ranges] = rangeReader(rrngFile); % read rrng file
rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix
[x,y,z,m]=readpos(fileName); % read pos file

%% Peak overlap stuff
% For peak deconvolution
overlapY = cell(size(overlaps));
overlapTable = cell(size(overlaps)); % a rangeTable like entry for the overlaping ion data

overlap_num = length(overlaps);
for o = 1:overlap_num
    overlapY{o} = peakHeights(overlaps{o});
    overlapTable{o} = ions2ionTable(overlaps{o},rangeElements);
end

%% bin data
edges=min(z):binwidth:max(z);
[~,point]=histc(z,edges);
count = length(edges)-1;

%% deconvolute each point
[clusterRangeTablesIonic,ionq,clusterRangeTables,clusterRangeCounts,smallList] = clusterDecompTablesIonicMLE(x,y,z,m,point,0,zeros(count,1),rangeTable,rangeElements,overlapY,overlapTable);

%% calculate the decomposed cluster compostions
clusterDecomposedCounts = zeros(count,length(rangeElements));
for c=1:count
    clusterDecomposedCounts(c,:) = clusterRangeCounts(c,:)*clusterRangeTables{c}(:,3:end);
end

% process output
comp_LP = 100*clusterDecomposedCounts./repmat(sum(clusterDecomposedCounts,2),1,size(clusterDecomposedCounts,2));
plot(edges(1:end-1),comp_LP);
legend(rangeElements);
title('Deconvoluted');
figure
% as-ranged data (no deconvolution)
normalLP = clusterRangeCounts*rangeTable(:,3:end);
normalLPc = 100*normalLP./repmat(sum(normalLP,2),1,size(normalLP,2));
subplot(1,2,1);plot(edges(1:end-1),normalLPc);title('Before');
subplot(1,2,2);plot(edges(1:end-1),comp_LP);title('After');
legend(rangeElements);