% simulates cl in the atmosphere
% Cl2 -k1->2Cl
% 2Cl -k2-> Cl2
% Cl+O3 -k3->ClO+O2
% ClO+O3 -k4->Cl+2O2

% boundary conditions
Cl2 = 3;
O3 = 6;
O2 = 0;
Cl = 0;
ClO = 0;

% rate constants
k = [1 1 2 1];

% set total steps
totalSteps = 1000;
scale = 300; % set scale
results = zeros(totalSteps,6);
tstep = 1;
while(tstep<=totalSteps)
    % calc rates
    dCl2 = -k(1)*Cl2+k(2)*Cl*Cl;
    dCl = k(1)*Cl2-k(2)*Cl*Cl-k(3)*Cl*O3+k(4)*ClO*O3;
    dO3 = -k(3)*Cl*O3-k(4)*ClO*O3;
    dO2 = k(3)*Cl*O3+2*k(4)*ClO*O3;
    dClO = k(3)*Cl*O3-k(4)*ClO*O3;
    % calc new concentrations
    Cl2 = Cl2 + dCl2/scale;
    O3 = O3 + dO3/scale;
    O2 = O2 + dO2/scale;
    Cl = Cl + dCl/scale;
    ClO = ClO + dClO/scale;
    % store results
    results(tstep,1) = tstep;
    results(tstep,2) = Cl2;
    results(tstep,3) = Cl;
    results(tstep,4) = O3;
    results(tstep,5) = O2;
    results(tstep,6) = ClO;
    %disp(Cl2);
    tstep = tstep + 1;
end
plot(results(:,2:6));
legend('Cl_2','Cl','O_3','O_2','ClO');
xlabel('Time'); ylabel('Concentration');