function [extentIVAS]=ivasExtent(positions)
%[extent]=ivasExtent(positions)
% From a list of 3d positions (columns = x y z), get the ivas definition of
% extent larger of mean-min or max-min
c=1;
ex1 = mean(positions(:,1))-min(positions(:,1));
ex2 = max(positions(:,1))-mean(positions(:,1));
ey1 = mean(positions(:,2))-min(positions(:,2));
ey2 = max(positions(:,2))-mean(positions(:,2));
ez1 = mean(positions(:,3))-min(positions(:,3));
ez2 = max(positions(:,3))-mean(positions(:,3));
if ex1>ex2
    extentIVAS(c,1) = ex1;
else
    extentIVAS(c,1) = ex2;
end
if ey1>ey2
    extentIVAS(c,2) = ey1;
else
    extentIVAS(c,2) = ey2;
end
if ez1>ez2
    extentIVAS(c,3) = ez1;
else
    extentIVAS(c,3) = ez2;
end
end