function [p,idx]=ismemberRanges(massList,ranges)
%[p,idx]=ismemberRanges(massList,ranges)
% Takes a list of masses and a range table (like that produced by
% rangeReader and returns whether those masses are ranged and which range
% they belong to.
% The range table should be formatted like this:
% 1          2        (3)   (4)      5            4+element_num
% rangeStart rangeEnd (vol) (colour) element1 ... elementN
% ***WITH COLUMNS 3 AND 4 MISSING AND ALL AS SINGLE/DOUBLE FLOATS***
% Where element1 is the number of elements in that ion in that range
% A London Nov 2015
p = zeros(length(massList),1);
idx = zeros(length(massList),1);
for i = 1:length(massList)
    temp = find(massQuant(massList(i),ranges));
    if isempty(temp)
        idx(i) = 0; % if the index is not found then set it to zero
    else
        idx(i) = temp;
        p(i) = 1;
    end
end
end