function [ionsFile] = ionsDataMaka(elements_char)
% [ionsFile] = ionsDataMaka(elements_char)
% This function makes an ionData.xls table the can be used for decomposing
% ions into their constitute elements

% What elements are present in the data?
% Get elements from user
%elements_char = ['Fe';'Cr';'Y ';'Ti';'O ';'C ';'N ';'Si';'Ar';'Mn';'W ';'Ga'];

% Will write to file:
ionsFile = 'ionsData.xls';

% Convert character array into an array of strings
elements = cellstr(elements_char);
% the number of elments is:
num_e = length(elements);
if(num_e < 1)
    % no elements detected
    disp('No elements detected!');
    return
end
% Max different elements per ion
max_ie = 3;
% max of each element per molecular ion
max_iee = 3;
% max atoms per molecular ion
max_ia = 3;
% results array storing all ion possibilities
if(max_ie == 1)
    ions = num2cell(zeros((num_e*num_e*max_iee),num_e+1));
elseif(max_ie == 2)
    ions = num2cell(zeros(num_e*num_e*max_iee*(2*max_iee+1),num_e+1));
elseif(max_ie == 3)
    ions = num2cell(zeros(num_e*num_e*max_iee*(2*max_iee*max_iee+2*max_iee+1),num_e+1));
else
    disp('invalid max number of elements to include (max 3)');
end
% result ion counter
counter = 1;

%make all zeros
for i=1:1E0 %this is HORRID. GET RID OF IT. The issue is I don't know how long ions needs to be.
    for j = 1:(num_e+1)
        ions{i,j} = 0;
    end
end
%disp(ions);

for a = 1:num_e % loop through all the elements
    for iee0 = 1:max_iee
        if((iee0)<=max_ia) % set max atoms per ion limitation
            if(iee0==1) % format should be FeO2 not Fe1O2
                base=elements{a}; % simply 'Fe'
            else
                base=strcat(elements{a},dec2base(iee0,10)); % 'Fe2'
            end
            % now add another element
            if (max_ie>1)
                for b = 1:num_e
                    if(b~=a)
                        for iee1 = 1:max_iee
                            if((iee0+iee1)<=max_ia) % set max atoms per ion limitation
                                if(iee1==1) % format should be FeO2 not Fe1O2
                                    add1=elements{b}; % simply 'Fe'
                                else
                                    add1=strcat(elements{b},dec2base(iee1,10)); % 'Fe2'
                                end
                                % now add another element
                                if(max_ie>2)
                                    for c = 1:num_e
                                        if(b~=a && c~=a && c~=b)
                                            for iee2 = 1:max_iee
                                                if((iee0+iee1+iee2)<=max_ia) % set max atoms per ion limitation
                                                    
                                                    if(iee2==1) % format should be FeO2 not Fe1O2
                                                        add2=elements{c}; % simply 'Fe'
                                                    else
                                                        add2=strcat(elements{c},dec2base(iee2,10)); % 'Fe2'
                                                    end
                                                    % now add another element
                                                    if(max_ie>3)
                                                        disp('Cant add anymore elements to ion');
                                                    end
                                                    ions{counter,1+a} = iee0;
                                                    ions{counter,1+b} = iee1;
                                                    ions{counter,1+c} = iee2;
                                                    %make 3 element ion
                                                    ions{counter} = strcat(base,add1,add2); % 'Fe2OC' etc
                                                    counter = counter + 1;
                                                end
                                            end
                                        end
                                    end
                                    ions{counter,1+a} = iee0;
                                    ions{counter,1+b} = iee1;
                                    %make 2 element ion
                                    ions{counter} = strcat(base,add1); % 'Fe2O' etc
                                    counter = counter + 1;
                                else
                                    ions{counter,1+a} = iee0;
                                    ions{counter,1+b} = iee1;
                                    %make 2 element ion
                                    ions{counter} = strcat(base,add1); % 'Fe2O' etc
                                    counter = counter + 1;
                                end
                            end
                        end
                    end
                end
                ions{counter,1+a} = iee0;
                %make 1 element ion
                ions{counter} = strcat(base); % 'Fe,Fe2' etc
                counter = counter + 1;
            else
                %make 1 element ion
                ions{counter,1+a} = iee0;
                ions{counter} = strcat(base); % 'Fe,Fe2' etc
                counter = counter + 1;
            end
        end
    end
end
origLength = length(ions);
for i=1:origLength
    if (ions{i}~=0)
        %do nothing
    else
        %remove rows
        ions(i:origLength,:)=[];
        break
    end
end
% write ions data to file so we don't have to generate it more than once
xlswrite(ionsFile,num_e,1,'A1');
xlswrite(ionsFile,transpose(elements),1,'B1');
xlswrite(ionsFile,ions,1,'A2');

end