function [ionTable,elements,chargeState]=ions2ionTable(ions,elements)
%[ionTable,elements]=ions2ionTable(ions,{elements})
%Takes an ion cell array eg: {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'}};
%and turns it into a matrix ion table: (ions) by (elements)
%       Ti O Cr
%(ion1) 1  1 0
%(ion2) 0  2 0
%(ion3) 0  1 1
% for decomposition of range counts into atomic counts.
% The elements cell array input is opptional, if none is supplied a new one
% will be created from the elements present in the ions list.
% A. London Sept 2013

ion_num = length(ions);
u = horzcat(ions{:});
% u = ions{1};
% for i = 2:ion_num
%     u = [u ions{i}];
% end

if nargin < 2
    % no elements list supplied, make our own elements list, with hookers
    % and blackjack! In fact, forget the hookers and blackjack...
    elements = unique(u(cellfun(@ischar,u)),'stable');
else
    % check the elements in overlaps are in the supplied elements list
    olelements = unique(u(cellfun(@ischar,u)),'stable');
    for i = 1:length(olelements)
        if ~sum(strcmp(olelements{i},elements))
            error('a:a',strcat('Missing element from ions in range file\nCould not find:',olelements{i},' in the elements list'));
            % now I could add another column to ranges and add the element to
            % range elements, but you probably need to check what you're doing
        end
    end
end
ionTable = zeros(ion_num,length(elements));
chargeState = ones(1,ion_num);
for i = 1:ion_num
    chargeState(i) = ions{i}{1};
    for j = 2:length(ions{i})
        if ischar(ions{i}{j})
            % is an element
            % get element position
            en = find(strcmp(ions{i}{j},elements));
            % look for number
            if j<length(ions{i})
                if isnumeric(ions{i}{j+1})
                    % set element amount
                    ionTable(i,en) = ions{i}{j+1};
                else
                    % no number, therefore 1
                    ionTable(i,en) = 1;
                end
            else
                % at end therefore 1
                ionTable(i,en) = 1;
            end
        end % if numeric do nothing
    end
end
end