function [ionStr]=ions2ionStrChrg(ions)
%[ionStr]=ions2ionStr(ions)
% Takes the cell definition of ions and returns a cell of natural ion names
% via an ion table.
% A London Dec 2014
chrgList =  cellfun(@(x) repmat('+',1,x{1}),ions,'uni',0)'; % get charge state

[ionTable,elements]=ions2ionTable(ions);
% sort the elements (AJL custom order)
[elements, ia] = elementSort(elements,{'Fe','Cr','Y','Ti','W','Si','O','C','N','H'});
ionTable = ionTable(:,ia);
[ionStr]=strcat(makeIon(ionTable,elements)',chrgList);
end