function [ionStr]=ions2ionStr(ions)
%[ionStr]=ions2ionStr(ions)
% Takes the cell definition of ions and returns a cell of natural ion names
% via an ion table.
% A London Dec 2014
[ionTable,elements]=ions2ionTable(ions);
% sort the elements (AJL custom order)
[elements, ia] = elementSort(elements,{'Fe','Cr','Y','Ti','W','Si','O','C','N','H'});
ionTable = ionTable(:,ia);
[ionStr]=makeIon(ionTable,elements);
end