function [ions]=ionTable2ions(ionTable,elements,chargeState)
% [ions]=ionTable2ions(ionTable,elements)
% Takes a matrix of elements per ion (or range) and returns a list ions in
% the format:
% Ion1          Ion2      Ion3
% {{2,'Ti','O'} {1,'O',2} {2,'Cr','O'}};
% A. London Sept 2013
if ~exist('chargeState','var')
   chargeState = ones(size(ionTable,1)); 
end
ion_num = length(ionTable(:,1));
ions = cell(1,ion_num);
for i = 1:ion_num
    ix = 2; % current ion index
    ions{i}{1} = chargeState(i);
    for c = 1:length(elements)
        if ionTable(i,c)
            % add element to ions
            ions{i}{ix} = elements{c};
            ix = ix +1;
            % add count to elements
            ions{i}{ix} = ionTable(i,c);
            ix = ix +1;
        end
    end
end
end