function [ionCell]=ionStr2ions(ionStr,chargeState)
%[ionCell]=ionStr2ions(ionStr,{chargeState})
% turns 'Ti2O' into {{1,'Ti',2,'O',1}}

% check for chargeSet vargin
if nargin < 1
    error('Please give an ion string, eg: {`TiO`,`O2`}');
end
if ischar(ionStr)
    ionStr = {ionStr}; % convert to cell array
end
if nargin < 2
    %disp('Setting charge state = 1');
    chargeState = ones(1,length(ionStr));
end

ionCell = cell(1,length(ionStr));
for i = 1:length(ionStr);
    str = ionStr{i};
    index = 2;
    ionCell{i}(1) = {chargeState(i)}; % set charege state
    numOfElements = length(regexp(str,'(?:[A-Z])')); % caps
    orderList = zeros(1,numOfElements);
    % using these 5 cases we should be able to do this using regexps:
    [a,~,~,b]=regexp(str,'(?:([A-Z][a-z]\d)|([A-Z]\d))'); % AaX or AX
    for j = 1:length(b)
        ionCell{i}{index} = b{j}(isletter(b{j}));
        orderList(index) = a(j);
        ionCell{i}{index+1} = str2double(b{j}(~isletter(b{j})));
        orderList(index+1) = a(j)+0.5;
        index = index + 2;
    end
    % Aa(A or end) or %A(A or end), number = 1
    [a,~,~,b]=regexp(str,'(?:(([A-Z][a-z]|[A-Z])(?=[A-Z]|$)))');
    for j = 1:length(b)
        ionCell{i}{index} = b{j}(isletter(b{j}));
        orderList(index) = a(j);
        ionCell{i}(index+1) = {1};
        orderList(index+1) = a(j)+0.5;
        index = index + 2;
    end
    % finally sort the list
    [~,Iorder] = sort(orderList);
    ionCell{i} = ionCell{i}(Iorder);
end
end
