function [ions] = ionList(ranges,elements,colAdjustFlag)
% takes 'ranges' returned by rangeReader and returns a
% cell array of ions, eg: Fe:0 Ti:1 O:2 -> TiO2
% colAdjustFlag = 1 if you want to just pass the ion-table from a range
% file only
if exist('colAdjustFlag','var')
    uList = unique(cell2mat(ranges),'rows','stable'); % unique list
else
    uList = unique(cell2mat(ranges(:,5:end)),'rows','stable'); % unique list
end
ions = makeIon(uList,elements);
end