function [counts]=ionCount(ions)
%[counts]=ionCount(ions)
% From a list of ions return the number of atoms in each ion
% A London Dec 2014
if iscell(ions{1}{1}) % a cell of ions
    list_num = length(ions);
    wrap = 0;
elseif isnumeric(ions{1}{1}) % list of ions
    ions = {ions}; % wrap to be like a list
    list_num = 1;
    wrap = 1;
else
    error(strcat('Unexpected data type:',ions{1}{1}));
end

counts = cell(list_num,1);
for o=1:list_num
    %ion_num = length(ions{o});
    [ionTable,~]=ions2ionTable(ions{o});
    counts{o} = sum(ionTable,2);
end
% unwrap
if wrap
    counts = cell2mat(counts);
end