% measure inhomogenity
cachedResult = 1;
[d,cols]=dataBase('run>0',1); % load data
i = 1; % which data set to use
headers = {'run','mat','matCode','irrdT1','irrdDpa1','irrdT2','irrdDpa2'}; % cell of strings from cols
subdiv = 8; steps=1; % pixel range and step size
reps = 10; % repeat the box sampling and H-measure this many times
contFlag = 0;
H = zeros(reps,((subdiv-2)/steps+1));
h = zeros(reps,((subdiv-2)/steps+1));
gscale = zeros(reps,((subdiv-2)/steps+1));
tresult = zeros(reps);
if cachedResult
    load('inhomo-reps.mat','posSample','posVolume');
else
    posSample = cell(reps,1);
    posVolume = zeros(reps,1);
end
for j=1:reps%size(d,1) % for each file in turn
    % read pos file
    posFile = strcat(d{i,strcmp('reconRoot',cols)},d{i,strcmp('pos',cols)});
    disp(posFile);
    cf = strcat('C:\users\andy\apt\clusterAnalysis\',d{i,strcmp('cf',cols)});
    % get file size
    %fileInfo = dir(posFile);
    %fileSize = fileInfo.bytes;
    % read only .9 (90%) of the file instead:
    %[x,y,z,~]=readpospart(posFile,round(.90*(fileSize/16)),fileSize/16);
    %[x,y,z,~]=readpos(posFile);
    %ranges = [min(x) max(x);min(y) max(y);0 max(z)];
    %clear x y z
    tic
    if ~cachedResult
        [ranges,posVolume(j)]=maxBox(posFile,8000,10000);
        ranges = ranges';
        posSample{j}=ranges; % store the sampled volume
    else
        ranges = posSample{j};
    end
    tresult(j)=toc;
    disp(['Time remaining:' num2str(  (reps-j)*mean(tresult(tresult>0))/60 ,3) ' min']);
    [~,~,~,positions] = clusterExtent(cf);
    % crop so that clusters outside are not passes to inK
    positions = positions(~(sum(positions<repmat(ranges(:,1)',size(positions,1),1),2) | sum(positions>repmat(ranges(:,2)',size(positions,1),1),2)),:);
    [H(j,:),h(j,:),gscale(j,:),~]=inK(ranges,positions,subdiv,steps);
    if contFlag
        try
            [A1,b1,c1,~]=inK_control(ranges,positions,subdiv,steps);
        catch
            [A1,b1,c1,~]=inK_control(ranges,positions,subdiv,steps);
        end
        plot(gscale(j,:),H(j,:),'k-',c1,A1,'r-');title(num2str(d{i,1}));
        saveas(gcf,['Inhomogenity\inhomogen' num2str(d{i,1}) '-' num2str(j) '.png']);
    end
end
plot(mean(gscale',2),mean(H',2),'x-',gscale',H','o');
xlabel('Scale nm');ylabel('Inhomogenity H');
title([num2str(reps) ' repeat samples of H from ' d{i,strcmp('pos',cols)}]);
% % export data:
% exprt = cell(numel(H),length(headers)+2);
% for i=1:length(headers)
%     exprt(:,i) = reshape(repmat(d(:,strcmp(headers{i},cols)),1,((subdiv-2)/steps+1))',[],1); % runs
% end
% exprt(:,length(headers)+1) = num2cell(reshape(H',[],1)); % H
% exprt(:,length(headers)+2) = num2cell(reshape(gscale',[],1)); % gscale
% exprt = [[headers,{'H','gscale'}];exprt];
% cell2csv('HmeasureBox3-reps.csv',exprt);
% beep