function [clusterIds] = indexedClusterMatrix(idxClrFile)
%[clusterIds] = indexedClusterMatrix(idxClrFile)
% takes a pos file and the indexed cluster pos file and returns a list for
% every ion in the original pos file which is clustered. Clustered ions are
% labelled with their cluster ID and unclustered ions are 0
% f = 'C:\Users\Andy\APT\R14_16469 C2\recons\recon-v01\default\R14_16469-v01.cluster.indexed.rrng';

[pathstr, name, ext] = fileparts(idxClrFile);

if strcmpi(ext,'.rrng')
    % assuming this is the .cluster.indexed.rrng file
    [~,idx]=regexp(idxClrFile,'[\w\\\:\s\-\.]+(?<=\-v0\d)');
    p = strcat(idxClrFile(1:idx(1)),'.pos'); % rename with .pos
    c = regexprep(idxClrFile,'.rrng','.pos'); % rename with .clustered.indexed.pos
    if ~exist(p,'file')
        error(['File:' p ' not found']);
    elseif ~exist(c,'file')
        error(['File:' c ' not found']);
    end
elseif strcmpi(ext,'.pos')
    % assuming this is the .cluster.indexed.pos file
    if ~exist(idxClrFile,'file')
        error(['File:' idxClrFile ' not found']);
    else
        [~,idx]=regexp(idxClrFile,'[\w\\\:\s\-\.]+(?<=\-v0\d)');
        c = idxClrFile;
        p = strcat(idxClrFile(1:idx(1)),'.pos'); % rename with .pos
    end
else
    error(['File extension not recognised:' ext]);
end

% check for cached result
newName = regexprep(c,'.pos','.list.mat');

if exist(newName,'file')
    load(newName); % load cached data (clusterIds)
else
    % make new data and save the result
    % load pos
    [x,y,z,m,np]=readpos(p);
    opos = [x' y' z'];
    clear x y z
    % load indexed pos
    [xc,yc,zc,mc,npc]=readpos(c);
    cpos = [xc' yc' zc'];
    clear xc yc zc
    % use is member to find clustered ions
    tic
    [~,Loc]=ismember(opos,cpos,'rows');
    toc
    % Loc are the locations in cpos
    % convert to cluster ids:
    clusterIds = zeros(size(m));
    for i=1:length(Loc)
        if Loc(i)
            clusterIds(i)=mc(Loc(i));
        end
    end
    clusterIds=clusterIds';
    % save list
    disp('Saving list');
    save(newName,'clusterIds'); % don't save as -ascii, .mat is 10000 times smaller
    disp(['Saved ' newName]);
end
end